/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.block;

import cofh.core.block.BlockCore;
import cofh.core.block.ItemBlockCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.ThermalFoundation;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockFlower
extends BlockCore
implements IInitializer,
IModelRegister,
IPlantable {
    protected static final AxisAlignedBB FLOWER_AABB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.6, 0.7);
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static ItemStack flowerCoal;
    public static ItemStack flowerRedstone;
    public static ItemStack flowerGlowstone;
    public static ItemStack flowerEnder;
    public static ItemStack flowerBlaze;
    public static ItemStack flowerBlizz;
    public static ItemStack flowerBlitz;
    public static ItemStack flowerBasalz;
    public static ItemStack flowerMana;

    public BlockFlower() {
        super(Material.field_151585_k, "thermalfoundation");
        this.func_149663_c("flower");
        this.func_149647_a(ThermalFoundation.tabCommon);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.COAL)));
        this.func_149675_a(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        return "tile.thermalfoundation.flower." + Type.values()[ItemHelper.getItemDamage((ItemStack)stack)].func_176610_l() + ".name";
    }

    public EnumRarity getRarity(ItemStack stack) {
        return Type.values()[ItemHelper.getItemDamage((ItemStack)stack)].getRarity();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    protected boolean canSustain(Block ground) {
        return ground == Blocks.field_150349_c || ground == Blocks.field_150346_d || ground == Blocks.field_150458_ak;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos from) {
        super.func_189540_a(state, world, pos, block, from);
        this.checkAndDropBlock(world, pos, state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(world, pos, state);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return this.canSustain(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return null;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return null;
    }

    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.values()[i].func_176610_l()));
        }
    }

    public boolean preInit() {
        this.setRegistryName("flower");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockCore itemBlock = new ItemBlockCore((BlockCore)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ThermalFoundation.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        COAL(0, "coal"),
        REDSTONE(1, "redstone"),
        GLOWSTONE(2, "glowstone"),
        ENDER(3, "ender"),
        BLAZE(4, "blaze"),
        BLIZZ(5, "blizz"),
        BLITZ(6, "blitz"),
        BASALZ(7, "basalz"),
        MANA(8, "mana");

        private final int metadata;
        private final String name;
        private final int light;
        private final EnumRarity rarity;

        private Type(int metadata, String name, int light, EnumRarity rarity) {
            this.metadata = metadata;
            this.name = name;
            this.light = light;
            this.rarity = rarity;
        }

        private Type(int metadata, String name, int light) {
            this(metadata, name, light, EnumRarity.COMMON);
        }

        private Type(int metadata, String name) {
            this(metadata, name, 0, EnumRarity.COMMON);
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }
    }
}

