/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.structure;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.DungeonHooks;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.block.BloodyCobblestoneConfig;

public class EvilDungeonStructure
extends WorldGenDungeons {
    private static final int RADIUS_X = 3;
    private static final int RADIUS_X_RAND = 4;
    private static final int RADIUS_Z = 3;
    private static final int RADIUS_Z_RAND = 4;
    private static final int CHESTS = 2;
    private static final int CHESTS_RAND = 2;

    public boolean func_180709_b(World world, Random random, BlockPos blockPos) {
        BlockPos loopPos;
        int zr;
        int yr;
        int xr;
        int height = 3;
        int radiusX = random.nextInt(4) + 3;
        int radiusZ = random.nextInt(4) + 3;
        int chests = random.nextInt(2) + 2;
        int openingCounter = 0;
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        for (xr = x - radiusX - 1; xr <= x + radiusX + 1; ++xr) {
            for (yr = y - 1; yr <= y + height + 1; ++yr) {
                for (zr = z - radiusZ - 1; zr <= z + radiusZ + 1; ++zr) {
                    loopPos = new BlockPos(xr, yr, zr);
                    if (!((ChunkProviderServer)world.func_72863_F()).func_73149_a(xr / 16, yr / 16)) {
                        return false;
                    }
                    Material material = world.func_180495_p(loopPos).func_185904_a();
                    if (yr == y - 1 && !material.func_76220_a()) {
                        return false;
                    }
                    if (yr == y + height + 1 && !material.func_76220_a()) {
                        return false;
                    }
                    if (xr != x - radiusX - 1 && xr != x + radiusX + 1 && zr != z - radiusZ - 1 && zr != z + radiusZ + 1 || yr != y || !world.func_175623_d(loopPos) || !world.func_175623_d(loopPos.func_177982_a(0, 1, 0))) continue;
                    ++openingCounter;
                }
            }
        }
        if (openingCounter >= 1 && openingCounter <= 15) {
            BlockPos loopPos2;
            for (xr = x - radiusX - 1; xr <= x + radiusX + 1; ++xr) {
                for (yr = y + height; yr >= y - 1; --yr) {
                    for (zr = z - radiusZ - 1; zr <= z + radiusZ + 1; ++zr) {
                        loopPos = new BlockPos(xr, yr, zr);
                        if (xr != x - radiusX - 1 && yr != y - 1 && zr != z - radiusZ - 1 && xr != x + radiusX + 1 && yr != y + height + 1 && zr != z + radiusZ + 1) {
                            world.func_175698_g(loopPos);
                            continue;
                        }
                        if (yr >= 0 && !world.func_180495_p(loopPos.func_177982_a(0, -1, 0)).func_185904_a().func_76220_a()) {
                            world.func_175698_g(loopPos);
                            continue;
                        }
                        if (!world.func_180495_p(loopPos).func_185904_a().func_76220_a()) continue;
                        if (yr == y - 1 && random.nextInt(4) != 0) {
                            if (!Configs.isEnabled(BloodyCobblestoneConfig.class)) continue;
                            world.func_180501_a(loopPos, BloodyCobblestoneConfig._instance.getBlockInstance().func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a(loopPos, Blocks.field_150347_e.func_176223_P(), 2);
                    }
                }
            }
            int attempts = 100;
            for (int xr2 = 0; xr2 < attempts && chests > 0; ++xr2) {
                int zrr;
                int xrr = x + random.nextInt(radiusX * 2 + 1) - radiusX;
                loopPos2 = new BlockPos(xrr, y, zrr = z + random.nextInt(radiusZ * 2 + 1) - radiusZ);
                if (!world.func_175623_d(loopPos2)) continue;
                int wallCounter = 0;
                if (world.func_180495_p(loopPos2.func_177982_a(-1, 0, 0)).func_185904_a().func_76220_a()) {
                    ++wallCounter;
                }
                if (world.func_180495_p(loopPos2.func_177982_a(1, 0, 0)).func_185904_a().func_76220_a()) {
                    ++wallCounter;
                }
                if (world.func_180495_p(loopPos2.func_177982_a(0, 0, -1)).func_185904_a().func_76220_a()) {
                    ++wallCounter;
                }
                if (world.func_180495_p(loopPos2.func_177982_a(0, 0, 1)).func_185904_a().func_76220_a()) {
                    ++wallCounter;
                }
                if (wallCounter != 1) continue;
                world.func_180501_a(loopPos2, Blocks.field_150486_ae.func_176223_P(), 2);
                TileEntityChest tileentitychest = (TileEntityChest)world.func_175625_s(loopPos2);
                if (tileentitychest != null) {
                    tileentitychest.func_189404_a(LootTableList.field_186422_d, world.field_73012_v.nextLong());
                }
                --chests;
            }
            for (int xs = x - 1; xs <= x + 1; xs += 2) {
                for (int zs = z - 1; zs <= z + 1; zs += 2) {
                    loopPos2 = new BlockPos(xs, y, zs);
                    world.func_180501_a(loopPos2, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.func_175625_s(loopPos2);
                    if (tileentitymobspawner != null) {
                        tileentitymobspawner.func_145881_a().func_190894_a(this.pickMobSpawner(random));
                        continue;
                    }
                    System.err.println("Failed to fetch mob spawner entity at (" + xs + ", " + y + ", " + zs + ")");
                }
            }
            return true;
        }
        return false;
    }

    private ResourceLocation pickMobSpawner(Random par1Random) {
        return DungeonHooks.getRandomDungeonMob((Random)par1Random);
    }
}

