/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.weather;

import java.lang.reflect.Field;
import net.minecraft.world.World;
import org.cyclops.evilcraft.core.weather.WeatherTypeAny;
import org.cyclops.evilcraft.core.weather.WeatherTypeClear;
import org.cyclops.evilcraft.core.weather.WeatherTypeLightning;
import org.cyclops.evilcraft.core.weather.WeatherTypeRain;

public abstract class WeatherType {
    public static final WeatherType ANY = new WeatherTypeAny();
    public static final WeatherType CLEAR = new WeatherTypeClear();
    public static final WeatherType RAIN = new WeatherTypeRain();
    public static final WeatherType LIGHTNING = new WeatherTypeLightning();
    public static final WeatherType[] WEATHER_TYPES = new WeatherType[]{CLEAR, RAIN, LIGHTNING};
    private final String name;

    protected WeatherType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public abstract boolean isActive(World var1);

    public abstract void activate(World var1);

    public abstract void deactivate(World var1);

    public void activate(World world, boolean activate) {
        if (activate) {
            this.activate(world);
        } else {
            this.deactivate(world);
        }
    }

    public static WeatherType getActiveWeather(World world) {
        for (WeatherType type : WEATHER_TYPES) {
            if (!type.isActive(world)) continue;
            return type;
        }
        return null;
    }

    public static WeatherType valueOf(String type) {
        Field field;
        try {
            field = WeatherType.class.getField(type);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        try {
            return (WeatherType)field.get(null);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

