/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacityConfig;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.fluid.SimulatedFluidStack;

public class BlockTankHelpers {
    private BlockTankHelpers() {
    }

    public static boolean onBlockActivatedTank(World world, BlockPos blockPos, EntityPlayer player, EnumHand hand, EnumFacing side, float motionX, float motionY, float motionZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        TankInventoryTileEntity tile = (TankInventoryTileEntity)world.func_175625_s(blockPos);
        if (tile != null && !itemStack.func_190926_b()) {
            SimulatableTankWrapper tank = new SimulatableTankWrapper(tile.getTank());
            IFluidHandlerItem itemFluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
            if (!player.func_70093_af() && !tank.isFull() && itemFluidHandler != null) {
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, (EntityPlayer)player, (boolean)true);
                if (result.isSuccess() && !player.field_71075_bZ.field_75098_d) {
                    InventoryHelpers.tryReAddToStack((EntityPlayer)player, (ItemStack)itemStack, (ItemStack)result.getResult(), (EnumHand)hand);
                }
                return true;
            }
            if (player.func_70093_af() && !tank.isEmpty()) {
                FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, (EntityPlayer)player, (boolean)true);
                if (result.isSuccess() && !player.field_71075_bZ.field_75098_d) {
                    InventoryHelpers.tryReAddToStack((EntityPlayer)player, (ItemStack)itemStack, (ItemStack)result.getResult(), (EnumHand)hand);
                }
                return true;
            }
        }
        return false;
    }

    public static String getInfoTank(ItemStack itemStack) {
        int amount = 0;
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
        if (fluidStack != null) {
            amount = fluidStack.amount;
        }
        IFluidHandlerItemCapacity fluidHandlerItemCapacity = (IFluidHandlerItemCapacity)FluidUtil.getFluidHandler((ItemStack)itemStack);
        return DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)amount, (int)fluidHandlerItemCapacity.getCapacity());
    }

    public static ItemStack tileDataToItemStack(TileEntity tile, ItemStack itemStack) {
        FluidActionResult res;
        IFluidHandler fluidHandlerTile;
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && itemStack.hasCapability(FluidHandlerItemCapacityConfig.CAPABILITY, null) && (fluidHandlerTile = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) instanceof IFluidTank) {
            IFluidTank fluidTank = (IFluidTank)fluidHandlerTile;
            IFluidHandlerItemCapacity fluidHandlerItemCapacity = (IFluidHandlerItemCapacity)itemStack.getCapability(FluidHandlerItemCapacityConfig.CAPABILITY, null);
            fluidHandlerItemCapacity.setCapacity(fluidTank.getCapacity());
            itemStack = fluidHandlerItemCapacity.getContainer();
        }
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (res = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)(fluidHandlerTile = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)), (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
            itemStack = res.getResult();
        }
        return itemStack;
    }

    public static void itemStackDataToTile(ItemStack itemStack, TileEntity tile) {
        IFluidHandler fluidHandlerTile;
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && itemStack.hasCapability(FluidHandlerItemCapacityConfig.CAPABILITY, null) && (fluidHandlerTile = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) instanceof FluidTank) {
            FluidTank fluidTank = (FluidTank)fluidHandlerTile;
            IFluidHandlerItemCapacity fluidHandlerItemCapacity = (IFluidHandlerItemCapacity)itemStack.getCapability(FluidHandlerItemCapacityConfig.CAPABILITY, null);
            fluidTank.setCapacity(fluidHandlerItemCapacity.getCapacity());
        }
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            fluidHandlerTile = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)fluidHandlerTile, (int)Integer.MAX_VALUE, null, (boolean)true);
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().func_190926_b() && event.getItemStack().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof IBlockTank) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new BlockTankHelpers());
    }

    public static class SimulatableTankWrapper
    implements IFluidHandler {
        private final SingleUseTank tank;

        public SimulatableTankWrapper(SingleUseTank tank) {
            this.tank = tank;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.tank.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.tank.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack drained = this.tank.drain(resource, doDrain);
            return doDrain ? drained : new SimulatedFluidStack(drained.getFluid(), drained.amount);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack drained = this.tank.drain(maxDrain, doDrain);
            return doDrain ? drained : new SimulatedFluidStack(drained.getFluid(), drained.amount);
        }

        public boolean isFull() {
            return this.tank.isFull();
        }

        public boolean isEmpty() {
            return this.tank.isEmpty();
        }
    }
}

