/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.config.configurable;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlock;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.client.render.model.ModelInnerBlock;

public abstract class ConfigurableBlockWithInnerBlocks
extends ConfigurableBlock
implements IInformationProvider {
    protected final IBlockState[] INNER_BLOCKS = this.makeInnerBlockList();

    public ConfigurableBlockWithInnerBlocks(ExtendedConfig eConfig, Material material) {
        super(eConfig, material);
    }

    protected abstract IBlockState[] makeInnerBlockList();

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!BlockHelpers.isValidCreativeTab((Block)this, (CreativeTabs)tab)) {
            return;
        }
        for (int j = 0; j < this.INNER_BLOCKS.length; ++j) {
            list.add((Object)new ItemStack((Block)this, 1, j));
        }
    }

    public Item func_180660_a(IBlockState blockState, Random random, int zero) {
        return this.getBlockFromState(blockState).func_177230_c().func_180660_a(this.getBlockFromState(blockState), random, zero);
    }

    public ItemStack getPickBlock(IBlockState blockState, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.getBlockFromState(blockState).func_177230_c());
    }

    public String getInfo(ItemStack itemStack) {
        return L10NHelpers.localize((String)"tile.blocks.evilcraft.inner_block.info", (Object[])new Object[]{TextFormatting.ITALIC + this.getBlockFromMeta(itemStack.func_77952_i()).func_177230_c().func_149732_F()});
    }

    @SideOnly(value=Side.CLIENT)
    public void provideInformation(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
    }

    public int getMetadataFromBlock(Block block) {
        for (int i = 0; i < this.INNER_BLOCKS.length; ++i) {
            if (this.INNER_BLOCKS[i].func_177230_c() != block) continue;
            return i;
        }
        return -1;
    }

    protected abstract PropertyInteger getMetaProperty();

    public IBlockState getBlockFromState(IBlockState blockState) {
        if (blockState.func_177230_c() != this) {
            return this.INNER_BLOCKS[0];
        }
        return this.getBlockFromMeta((Integer)blockState.func_177229_b((IProperty)this.getMetaProperty()));
    }

    public IBlockState getBlockFromMeta(int blockMeta) {
        return this.INNER_BLOCKS[Math.min(this.INNER_BLOCKS.length - 1, blockMeta)];
    }

    public int getInnerBlocks() {
        return this.INNER_BLOCKS.length;
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos blockPos) {
        return this.getBlockFromState(blockState).func_177230_c().func_176195_g(blockState, world, blockPos);
    }

    public int func_180651_a(IBlockState blockState) {
        return (Integer)blockState.func_177229_b((IProperty)this.getMetaProperty());
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos blockPos, EntityPlayer player) {
        return true;
    }

    public float func_180647_a(IBlockState blockState, EntityPlayer player, World world, BlockPos blockPos) {
        return this.getBlockFromState(blockState).func_177230_c().func_180647_a(blockState, player, world, blockPos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState blockState, World world, RayTraceResult target, ParticleManager particleManager) {
        BlockPos pos = target.func_178782_a();
        RenderHelpers.addBlockHitEffects((ParticleManager)particleManager, (World)world, (IBlockState)this.getBlockFromState(blockState), (BlockPos)pos, (EnumFacing)target.field_178784_b);
        return true;
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IBakedModel createDynamicModel() {
        return new ModelInnerBlock(this);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColorHandler() {
        return new BlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public static class BlockColor
    implements IBlockColor {
        @SideOnly(value=Side.CLIENT)
        public int func_186720_a(IBlockState blockState, IBlockAccess world, BlockPos blockPos, int renderPass) {
            ConfigurableBlockWithInnerBlocks thisBlock;
            IBlockState blockStateInner;
            Block block;
            if (blockPos != null && (block = (blockStateInner = (thisBlock = (ConfigurableBlockWithInnerBlocks)blockState.func_177230_c()).getBlockFromState(world.func_180495_p(blockPos))).func_177230_c()) instanceof IBlockColor) {
                return ((IBlockColor)block).func_186720_a(blockStateInner, world, blockPos, renderPass);
            }
            return -1;
        }
    }
}

