/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.algorithm;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class OrganicSpread {
    private static Random random = new Random();
    private World world;
    private int dimensions;
    private int radius;
    private IOrganicSpreadable spreadable;

    public OrganicSpread(World world, int dimensions, int radius, IOrganicSpreadable spreadable) {
        this.world = world;
        this.setDimensions(dimensions);
        this.setRadius(radius);
        this.setSpreadable(spreadable);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
    }

    public IOrganicSpreadable getSpreadable() {
        return this.spreadable;
    }

    public void setSpreadable(IOrganicSpreadable spreadable) {
        this.spreadable = spreadable;
    }

    public void spreadTick(BlockPos startLocation) {
        Vec3d newLocation = new Vec3d((double)startLocation.func_177958_n(), (double)startLocation.func_177956_o(), (double)startLocation.func_177952_p());
        BlockPos newLocationConcrete = new BlockPos(newLocation);
        Vec3d direction = this.getRandomDirection();
        for (int attempts = 10; !this.isBigEnough(direction) && attempts > 0; --attempts) {
            direction = this.getRandomDirection();
        }
        if (!this.isBigEnough(direction)) {
            return;
        }
        while (this.getSpreadable().isDone(this.world, newLocationConcrete) && this.isInArea(startLocation, newLocationConcrete)) {
            newLocation = newLocation.func_178787_e(direction);
            newLocationConcrete = new BlockPos(newLocation);
        }
        if (!this.getSpreadable().isDone(this.world, newLocationConcrete)) {
            this.getSpreadable().spreadTo(this.world, newLocationConcrete);
        }
    }

    protected boolean isInArea(BlockPos center, BlockPos location) {
        return Math.sqrt(center.func_177951_i((Vec3i)location)) <= (double)this.getRadius();
    }

    protected boolean isBigEnough(Vec3d direction) {
        float MIN = 0.3f;
        return Math.abs(direction.field_72450_a) >= (double)MIN || Math.abs(direction.field_72448_b) >= (double)MIN || Math.abs(direction.field_72449_c) >= (double)MIN;
    }

    protected Vec3d getRandomDirection() {
        return new Vec3d((double)((random.nextFloat() * 2.0f - 1.0f) / 2.0f), (double)((random.nextFloat() * 2.0f - 1.0f) / 2.0f), (double)((random.nextFloat() * 2.0f - 1.0f) / 2.0f));
    }

    public static interface IOrganicSpreadable {
        public boolean isDone(World var1, BlockPos var2);

        public void spreadTo(World var1, BlockPos var2);
    }
}

