/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.model.DelegatingDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.block.BoxOfEternalClosure;

public class ModelBoxOfEternalClosureBaked
extends DelegatingDynamicItemAndBlockModel {
    protected static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> PERSPECTIVE_TRANSFORMS = ModelHelpers.modifyDefaultTransforms((Map)ImmutableMap.of((Object)ItemCameraTransforms.TransformType.GUI, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(30.0f, 45.0f, 0.0f)), new Vector3f(0.625f, 0.625f, 0.625f), null))));
    public static IBakedModel boxModel;
    public static IBakedModel boxLidModel;
    public static IBakedModel boxLidRotatedModel;
    private final boolean isOpen;

    public ModelBoxOfEternalClosureBaked() {
        this.isOpen = false;
    }

    public ModelBoxOfEternalClosureBaked(IBlockState blockState, EnumFacing facing, long rand) {
        super(blockState, facing, rand);
        this.isOpen = false;
    }

    public ModelBoxOfEternalClosureBaked(boolean isOpen, ItemStack itemStack, World world, EntityLivingBase entity) {
        super(itemStack, world, entity);
        this.isOpen = isOpen;
    }

    public List<BakedQuad> getGeneralQuads() {
        LinkedList quads = Lists.newLinkedList();
        quads.addAll(boxModel.func_188616_a(this.blockState, this.facing, this.rand));
        if (this.isOpen) {
            quads.addAll(boxLidRotatedModel.func_188616_a(this.blockState, this.facing, this.rand));
        } else {
            quads.addAll(boxLidModel.func_188616_a(this.blockState, this.facing, this.rand));
        }
        return quads;
    }

    public IBakedModel handleBlockState(IBlockState state, EnumFacing side, long rand) {
        return null;
    }

    public IBakedModel handleItemState(ItemStack itemStack, World world, EntityLivingBase entity) {
        return new ModelBoxOfEternalClosureBaked(BoxOfEternalClosure.getInstance().getSpiritNameOrNull(itemStack) == null, itemStack, world, entity);
    }

    public TextureAtlasSprite func_177554_e() {
        return boxModel.func_177554_e();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation tr = (TRSRTransformation)PERSPECTIVE_TRANSFORMS.get((Object)cameraTransformType);
        Matrix4f mat = null;
        if (tr != null && !tr.equals((Object)TRSRTransformation.identity())) {
            mat = TRSRTransformation.blockCornerToCenter((TRSRTransformation)tr).getMatrix();
        }
        return Pair.of((Object)((Object)this), mat);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelBoxOfEternalClosureBaked)) {
            return false;
        }
        ModelBoxOfEternalClosureBaked other = (ModelBoxOfEternalClosureBaked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.isOpen() == other.isOpen();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelBoxOfEternalClosureBaked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOpen() ? 79 : 97);
        return result;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public String toString() {
        return "ModelBoxOfEternalClosureBaked(isOpen=" + this.isOpen() + ")";
    }
}

