/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.ColossalBloodChest;
import org.cyclops.evilcraft.client.render.tileentity.RenderTileEntityColossalBloodChest;
import org.cyclops.evilcraft.core.config.extendedconfig.UpgradableBlockContainerConfig;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.tileentity.TileColossalBloodChest;
import org.cyclops.evilcraft.tileentity.TileWorking;

public class ColossalBloodChestConfig
extends UpgradableBlockContainerConfig {
    public static ColossalBloodChestConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The amount Blood mB required for repairing one damage value.", isCommandable=true)
    public static int baseMBPerDamage;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The amount of ticks required for repairing one damage value.", isCommandable=true)
    public static int ticksPerDamage;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The base amount of concurrent items that need to be available before efficiency can rise.", isCommandable=true)
    public static int baseConcurrentItems;

    public ColossalBloodChestConfig() {
        super((ModBase)EvilCraft._instance, true, "colossal_blood_chest", null, ColossalBloodChest.class);
    }

    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlockFluidContainer.class;
    }

    @Override
    public Set<Upgrades.Upgrade> getUpgrades() {
        return Sets.newHashSet((Object[])new Upgrades.Upgrade[]{TileWorking.UPGRADE_EFFICIENCY, TileWorking.UPGRADE_SPEED, TileWorking.UPGRADE_TIER1, TileWorking.UPGRADE_TIER2, TileWorking.UPGRADE_TIER3});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegistered() {
        super.onRegistered();
        ModelChest model = new ModelChest();
        ResourceLocation texture = new ResourceLocation("evilcraft", "textures/models/colossal_blood_chest.png");
        EvilCraft._instance.getProxy().registerRenderer(TileColossalBloodChest.class, (TileEntitySpecialRenderer)new RenderTileEntityColossalBloodChest(model, texture));
    }

    static {
        baseMBPerDamage = 10;
        ticksPerDamage = 2;
        baseConcurrentItems = 4;
    }
}

