/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.LocUtils;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;

public class ToolPart
extends MaterialItem
implements IToolPart {
    protected int cost;

    public ToolPart(int cost) {
        this.func_77637_a((CreativeTabs)TinkerRegistry.tabParts);
        this.cost = cost;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (Material mat : TinkerRegistry.getAllMaterials()) {
                if (!this.canUseMaterial(mat)) continue;
                subItems.add((Object)this.getItemstackWithMaterial(mat));
                if (Config.listAllPartMaterials) continue;
                break;
            }
        }
    }

    @Override
    public boolean canUseMaterial(Material mat) {
        for (ToolCore tool : TinkerRegistry.getTools()) {
            for (PartMaterialType pmt : tool.getRequiredComponents()) {
                if (!pmt.isValid(this, mat)) continue;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Material material = this.getMaterial(stack);
        boolean shift = Util.isShiftKeyDown();
        if (!this.checkMissingMaterialTooltip(stack, tooltip)) {
            tooltip.addAll(this.getTooltipTraitInfo(material));
        }
        if (Config.extraTooltips) {
            if (!shift) {
                tooltip.add("");
                tooltip.add(Util.translate("tooltip.tool.holdShift", new Object[0]));
            } else {
                tooltip.addAll(this.getTooltipStatsInfo(material));
            }
        }
        tooltip.addAll(this.getAddedByInfo(material));
    }

    public List<String> getTooltipTraitInfo(Material material) {
        ConcurrentMap mapping = Maps.newConcurrentMap();
        for (IMaterialStats stat : material.getAllStats()) {
            List<ITrait> traits;
            if (!this.hasUseForStat(stat.getIdentifier()) || (traits = material.getAllTraitsForStats(stat.getIdentifier())).isEmpty()) continue;
            boolean unified = false;
            for (Map.Entry entry : mapping.entrySet()) {
                if (!((List)entry.getValue()).equals(traits)) continue;
                mapping.put((String)entry.getKey() + ", " + stat.getLocalizedName(), entry.getValue());
                mapping.remove(entry.getKey());
                unified = true;
                break;
            }
            if (unified) continue;
            mapping.put(stat.getLocalizedName(), traits);
        }
        LinkedList tooltips = Lists.newLinkedList();
        boolean withType = mapping.size() > 1;
        for (Map.Entry entry : mapping.entrySet()) {
            StringBuilder sb = new StringBuilder();
            if (withType) {
                sb.append(TextFormatting.ITALIC.toString());
                sb.append((String)entry.getKey());
                sb.append(": ");
                sb.append(TextFormatting.RESET.toString());
            }
            sb.append(material.getTextColor());
            List traits = (List)entry.getValue();
            if (traits.isEmpty()) continue;
            ListIterator iter = traits.listIterator();
            sb.append(((ITrait)iter.next()).getLocalizedName());
            while (iter.hasNext()) {
                sb.append(", ").append(((ITrait)iter.next()).getLocalizedName());
            }
            tooltips.add(sb.toString());
        }
        return tooltips;
    }

    public List<String> getTooltipStatsInfo(Material material) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IMaterialStats stat : material.getAllStats()) {
            List<String> text;
            if (!this.hasUseForStat(stat.getIdentifier()) || (text = stat.getLocalizedInfo()).isEmpty()) continue;
            builder.add((Object)"");
            builder.add((Object)(TextFormatting.WHITE.toString() + TextFormatting.UNDERLINE + stat.getLocalizedName()));
            builder.addAll(stat.getLocalizedInfo());
        }
        return builder.build();
    }

    public List<String> getAddedByInfo(Material material) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (TinkerRegistry.getTrace(material) != null) {
            String materialInfo = I18n.func_74837_a((String)"tooltip.part.material_added_by", (Object[])new Object[]{TinkerRegistry.getTrace(material).getName()});
            builder.add((Object)"");
            builder.add((Object)materialInfo);
        }
        return builder.build();
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        Material material = this.getMaterial(stack);
        String locString = this.func_77658_a() + "." + material.getIdentifier();
        if (I18n.func_94522_b((String)locString)) {
            return Util.translate(locString, new Object[0]);
        }
        return material.getLocalizedItemName(super.func_77653_i(stack));
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.fontRenderer;
    }

    @Override
    public boolean hasUseForStat(String stat) {
        for (ToolCore tool : TinkerRegistry.getTools()) {
            for (PartMaterialType pmt : tool.getRequiredComponents()) {
                if (!pmt.isValidItem(this) || !pmt.usesStat(stat)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkMissingMaterialTooltip(ItemStack stack, List<String> tooltip) {
        return this.checkMissingMaterialTooltip(stack, tooltip, null);
    }

    public boolean checkMissingMaterialTooltip(ItemStack stack, List<String> tooltip, String statIdentifier) {
        Material material = this.getMaterial(stack);
        if (material == Material.UNKNOWN) {
            NBTTagCompound tag = TagUtil.getTagSafe(stack);
            String materialID = tag.func_74779_i("Material");
            String error = !materialID.isEmpty() ? I18n.func_74837_a((String)"tooltip.part.missing_material", (Object[])new Object[]{materialID}) : I18n.func_74838_a((String)"tooltip.part.missing_info");
            tooltip.addAll(LocUtils.getTooltips((String)error));
            return true;
        }
        if (statIdentifier != null && material.getStats(statIdentifier) == null) {
            tooltip.addAll(LocUtils.getTooltips((String)Util.translateFormatted("tooltip.part.missing_stats", material.getLocalizedName(), statIdentifier)));
            return true;
        }
        return false;
    }
}

