/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api;

import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface TweakProvider<T extends Container> {
    public String getModId();

    public boolean load();

    default public boolean requiresServerSide() {
        return true;
    }

    default public int getCraftingGridStart(EntityPlayer entityPlayer, T container, int id) {
        return 1;
    }

    default public int getCraftingGridSize(EntityPlayer entityPlayer, T container, int id) {
        return 9;
    }

    public void clearGrid(EntityPlayer var1, T var2, int var3, boolean var4);

    public void rotateGrid(EntityPlayer var1, T var2, int var3, boolean var4);

    public void balanceGrid(EntityPlayer var1, T var2, int var3);

    public void spreadGrid(EntityPlayer var1, T var2, int var3);

    public boolean canTransferFrom(EntityPlayer var1, T var2, int var3, Slot var4);

    public boolean transferIntoGrid(EntityPlayer var1, T var2, int var3, Slot var4);

    public ItemStack putIntoGrid(EntityPlayer var1, T var2, int var3, ItemStack var4, int var5);

    public IInventory getCraftMatrix(EntityPlayer var1, T var2, int var3);

    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiContainer var1, List<GuiButton> var2);

    default public boolean isValidContainer(Container container) {
        return true;
    }
}

