/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.tiles;

import com.m4thg33k.tombmanygraves.ModConfigs;
import com.m4thg33k.tombmanygraves.blocks.ModBlocks;
import com.m4thg33k.tombmanygraves.friends.FriendHandler;
import com.m4thg33k.tombmanygraves.invman.InventoryHolder;
import com.m4thg33k.tombmanygraves.items.ModItems;
import com.m4thg33k.tombmanygraves.util.ChatHelper;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileGrave
extends TileEntity {
    private static final String TAG_CAMO = "camo";
    private static final String TAG_CAMO_META = "camoMeta";
    private static final String SKULL_TAG = "SkullOwner";
    public static final String PLAYER_NAME = "PlayerName";
    public static final String ANGLE_OF_DEATH = "AngleOfDeath";
    public static final String LOCKED = "IsLocked";
    public static final String PLAYER_UUID = "PlayerID";
    public static final String GRAVE_PRIORITY = "GravePriority";
    private boolean GIVE_ITEMS_IN_GRAVE_PRIORITY = ModConfigs.GIVE_ITEMS_IN_GRAVE_PRIORITY;
    private boolean locked = ModConfigs.DEFAULT_TO_LOCKED;
    private String playerName = "M4thG33k";
    private UUID playerID = UUID.fromString("905379e2-068f-44c9-965b-6b9fbe1a6140");
    private int angle = 0;
    private boolean shouldRenderGround = false;
    private ItemStack skull = null;
    private IBlockState camoState;
    private String timestamp = "";
    private InventoryHolder savedInventory = new InventoryHolder();

    private void setPlayerName(@Nonnull String name) {
        this.playerName = name;
        this.setSkull();
    }

    public String getPlayerName() {
        return this.playerName;
    }

    private void setPlayerID(UUID id) {
        this.playerID = id;
    }

    public void setPlayer(EntityPlayer player) {
        this.setPlayerName(player.func_70005_c_());
        this.setPlayerID(player.func_110124_au());
        this.func_70296_d();
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }

    public void getPlayerData(@Nonnull EntityPlayer player) {
        this.angle = (int)player.field_70759_as;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.setPlayerName(player.func_70005_c_());
        this.setPlayerID(player.func_110124_au());
        this.func_70296_d();
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }

    public InventoryHolder getSavedInventory() {
        return this.savedInventory;
    }

    public void setSavedInventory(InventoryHolder holder) {
        this.savedInventory = holder;
        this.timestamp = holder.getTimestamp();
    }

    private void setSkull() {
        this.skull = new ItemStack(Items.field_151144_bL, 1, 3);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(SKULL_TAG, (NBTBase)new NBTTagString(this.playerName));
        this.skull.func_77982_d(compound);
    }

    public void onRightClick(@Nonnull EntityPlayer player) {
        if (this.hasAccess(player)) {
            this.toggleGravePriority();
            ChatHelper.sayMessage(player, this.GIVE_ITEMS_IN_GRAVE_PRIORITY ? "Grave items will be forced into their original slots" : "Items in your inventory will not move.");
        } else {
            ChatHelper.sayMessage(player, "You do not have permission to interact with this grave.");
        }
    }

    public boolean isSamePlayer(EntityPlayer player) {
        return ModConfigs.ALLOW_GRAVE_ROBBING || player.func_110124_au().equals(this.playerID);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.playerName = compound.func_74779_i(PLAYER_NAME);
        this.setSkull();
        this.angle = compound.func_74762_e(ANGLE_OF_DEATH);
        this.locked = compound.func_74767_n(LOCKED);
        this.playerID = compound.func_186857_a(PLAYER_UUID);
        this.GIVE_ITEMS_IN_GRAVE_PRIORITY = compound.func_74767_n(GRAVE_PRIORITY);
        Block b = Block.func_149684_b((String)compound.func_74779_i(TAG_CAMO));
        if (b != null) {
            this.camoState = b.func_176203_a(compound.func_74762_e(TAG_CAMO_META));
        }
        this.savedInventory = new InventoryHolder();
        this.savedInventory.readFromNBT(compound);
        this.timestamp = compound.func_74779_i("Timestamp");
        this.setShouldGroundRender();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a(PLAYER_NAME, this.playerName);
        compound.func_74768_a(ANGLE_OF_DEATH, this.angle);
        compound.func_74757_a(LOCKED, this.locked);
        if (this.playerID != null) {
            compound.func_186854_a(PLAYER_UUID, this.playerID);
        }
        compound.func_74757_a(GRAVE_PRIORITY, this.GIVE_ITEMS_IN_GRAVE_PRIORITY);
        if (this.camoState != null) {
            compound.func_74778_a(TAG_CAMO, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.camoState.func_177230_c())).toString());
            compound.func_74768_a(TAG_CAMO_META, this.camoState.func_177230_c().func_176201_c(this.camoState));
        }
        compound = this.savedInventory.writeToNBT(compound);
        compound.func_74778_a("Timestamp", this.timestamp);
        return compound;
    }

    private void toggleGravePriority() {
        this.GIVE_ITEMS_IN_GRAVE_PRIORITY = !this.GIVE_ITEMS_IN_GRAVE_PRIORITY;
        this.func_70296_d();
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }

    public void onCollision(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K || this.locked || !this.hasAccess(player)) {
            return;
        }
        this.removeCorrespondingDeathList(player);
        if (this.GIVE_ITEMS_IN_GRAVE_PRIORITY) {
            this.savedInventory.forceInventory(player);
        } else {
            this.savedInventory.insertInventory(player);
        }
        this.field_145850_b.func_175698_g(this.field_174879_c);
    }

    public void dropGraveContentsAt(World worldIn, BlockPos posIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.savedInventory.dropInventory(worldIn, posIn);
        this.field_145850_b.func_175698_g(this.field_174879_c);
    }

    public void dropGraveContentsHere() {
        this.dropGraveContentsAt(this.field_145850_b, this.field_174879_c);
    }

    private void removeCorrespondingDeathList(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            String time;
            NBTTagCompound tag;
            NBTTagCompound tagCompound;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.itemDeathList) continue;
            NBTTagCompound nBTTagCompound = tagCompound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            if (tagCompound == null || !tagCompound.func_74764_b("InventoryHolder") || !(tag = tagCompound.func_74775_l("InventoryHolder")).func_74764_b("Timestamp") || !(time = tag.func_74779_i("Timestamp")).equals(this.timestamp)) continue;
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.playerName = pkt.func_148857_g().func_74779_i(PLAYER_NAME);
        this.setSkull();
        this.angle = pkt.func_148857_g().func_74762_e(ANGLE_OF_DEATH);
        this.locked = pkt.func_148857_g().func_74767_n(LOCKED);
        this.playerID = pkt.func_148857_g().func_186857_a(PLAYER_UUID);
        this.GIVE_ITEMS_IN_GRAVE_PRIORITY = pkt.func_148857_g().func_74767_n(GRAVE_PRIORITY);
        Block b = Block.func_149684_b((String)pkt.func_148857_g().func_74779_i(TAG_CAMO));
        if (b != null) {
            this.camoState = b.func_176203_a(pkt.func_148857_g().func_74762_e(TAG_CAMO_META));
        }
        this.setShouldGroundRender();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        compound.func_82580_o("InventoryHolder");
        return compound;
    }

    @ParametersAreNonnullByDefault
    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public int getAngle() {
        return this.angle;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void toggleLock(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.hasAccess(player)) {
            boolean bl = this.locked = !this.locked;
            if (ModConfigs.ALLOW_LOCKING_MESSAGES) {
                ChatHelper.sayMessage(player, "The grave is now " + (this.locked ? "" : "un") + "locked!");
            }
            this.func_70296_d();
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        } else {
            ChatHelper.sayMessage(player, "You do not have permission to modify this grave.");
        }
    }

    public boolean isFriend(EntityPlayer player) {
        return FriendHandler.hasAsFriend(this.playerID, player.func_110124_au());
    }

    public boolean hasAccess(EntityPlayer player) {
        return ModConfigs.ALLOW_GRAVE_ROBBING || this.isSamePlayer(player) || this.isFriend(player);
    }

    public boolean getShouldRenderGround() {
        return this.shouldRenderGround;
    }

    public ItemStack getSkull() {
        return this.skull;
    }

    @ParametersAreNonnullByDefault
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return true;
    }

    public void setCamoState(IBlockState state) {
        this.camoState = state;
        this.setShouldGroundRender();
    }

    public IBlockState getCamoState() {
        return this.camoState;
    }

    public void setShouldGroundRender() {
        this.shouldRenderGround = this.camoState != null && this.camoState != ModBlocks.blockGrave.func_176223_P();
    }

    public boolean areGraveItemsForced() {
        return this.GIVE_ITEMS_IN_GRAVE_PRIORITY;
    }

    public void setTimestamp(String stamp) {
        this.timestamp = stamp;
        this.func_70296_d();
    }

    public String getTimestamp() {
        return this.timestamp;
    }
}

