/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.performance.audioreload.mixin;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigGeneral;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.ProgressManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundHandler.class})
public class UTAudioReloadMixin {
    @Shadow
    @Final
    private static Logger field_147698_b;
    @Shadow
    @Final
    public SoundManager field_147694_f;
    @Shadow
    @Final
    private SoundRegistry field_147697_e;

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/client/resources/IResourceManager;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void utOnResourceManagerReload(IResourceManager resourceManager, CallbackInfo info) {
        if (!UTConfigTweaks.PERFORMANCE.utDisableAudioDebugToggle) {
            return;
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTAudioReloadMixin ::: Resource manager reload");
        }
        this.field_147697_e.func_148763_c();
        LinkedList<Tuple<ResourceLocation, SoundList>> soundLists = new LinkedList<Tuple<ResourceLocation, SoundList>>();
        this.loadSoundLists(resourceManager, soundLists);
        this.loadSounds(soundLists);
        this.field_147694_f.func_148596_a();
        info.cancel();
    }

    @Unique
    public void loadSounds(List<Tuple<ResourceLocation, SoundList>> soundLists) {
        ProgressManager.ProgressBar resourcesBar = ProgressManager.push((String)"Loading sounds", (int)soundLists.size());
        for (Tuple<ResourceLocation, SoundList> soundList : soundLists) {
            resourcesBar.step(((ResourceLocation)soundList.func_76341_a()).toString());
            try {
                this.func_147693_a((ResourceLocation)soundList.func_76341_a(), (SoundList)soundList.func_76340_b());
            }
            catch (RuntimeException e) {
                field_147698_b.warn("Invalid sounds.json", (Throwable)e);
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)resourcesBar);
    }

    @Unique
    public void loadSoundLists(IResourceManager resourceManager, List<Tuple<ResourceLocation, SoundList>> soundLists) {
        for (String s : resourceManager.func_135055_a()) {
            try {
                for (IResource managerSoundList : resourceManager.func_135056_b(new ResourceLocation(s, "sounds.json"))) {
                    for (Map.Entry<String, SoundList> entry : this.func_175085_a(managerSoundList.func_110527_b()).entrySet()) {
                        soundLists.add((Tuple<ResourceLocation, SoundList>)new Tuple((Object)new ResourceLocation(s, entry.getKey()), (Object)entry.getValue()));
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }

    @Shadow
    protected Map<String, SoundList> func_175085_a(InputStream stream) {
        return null;
    }

    @Shadow
    private void func_147693_a(ResourceLocation location, SoundList sounds) {
    }
}

