/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.entities.trading.mixin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mod.acgaming.universaltweaks.tweaks.entities.trading.UTVillagerProfessionRestriction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityVillager.class})
public abstract class UTEntityVillagerMixin
extends EntityAgeable {
    @Shadow(remap=false)
    private VillagerRegistry.VillagerProfession prof;

    protected UTEntityVillagerMixin(World world) {
        super(world);
    }

    @Shadow
    public abstract void func_70938_b(int var1);

    @Inject(method={"setProfession(Lnet/minecraftforge/fml/common/registry/VillagerRegistry$VillagerProfession;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void utSetProfession(VillagerRegistry.VillagerProfession prof, CallbackInfo ci) {
        VillagerRegistry.VillagerProfession selectedProfession;
        this.prof = selectedProfession = this.ut$getValidProfession((EntityLivingBase)((EntityVillager)this), this.func_70681_au());
        this.func_70938_b(VillagerRegistry.getId((VillagerRegistry.VillagerProfession)selectedProfession));
        ci.cancel();
    }

    @Unique
    private VillagerRegistry.VillagerProfession ut$getValidProfession(EntityLivingBase villager, Random random) {
        BlockPos pos = new BlockPos((Entity)villager);
        Biome biome = villager.field_70170_p.func_180494_b(pos);
        String biomeRegName = biome.getRegistryName().toString();
        VillagerRegistry.VillagerProfession neet = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:nitwit"));
        ArrayList<VillagerRegistry.VillagerProfession> professions = new ArrayList<VillagerRegistry.VillagerProfession>(ForgeRegistries.VILLAGER_PROFESSIONS.getValuesCollection());
        UTVillagerProfessionRestriction.Entry configEntry = UTVillagerProfessionRestriction.VILLAGER_PROFESSION_MAP.get(biomeRegName);
        if (configEntry == null) {
            return (VillagerRegistry.VillagerProfession)professions.get(random.nextInt(professions.size()));
        }
        List<String> configProfessions = Arrays.asList(configEntry.professions);
        if (configEntry.mode.equals("whitelist")) {
            professions.removeIf(profession -> {
                ResourceLocation profName = profession.getRegistryName();
                return profName == null || !configProfessions.contains(profName.toString());
            });
        } else {
            professions.removeIf(profession -> {
                ResourceLocation profName = profession.getRegistryName();
                return profName != null && configProfessions.contains(profName.toString());
            });
        }
        if (professions.isEmpty()) {
            if (neet != null) {
                return neet;
            }
            return (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValuesCollection().stream().findFirst().orElseThrow(() -> new IllegalStateException("No villager professions available for biome: " + biomeRegName));
        }
        return (VillagerRegistry.VillagerProfession)professions.get(random.nextInt(professions.size()));
    }
}

