/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.config;

import com.cleanroommc.configanytime.ConfigAnytime;
import mod.acgaming.universaltweaks.util.compat.UTObsoleteModsHandler;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="universaltweaks", name="Universal Tweaks - General")
public class UTConfigGeneral {
    @Config.LangKey(value="cfg.universaltweaks.config.debug")
    @Config.Name(value="Debug")
    public static final DebugCategory DEBUG = new DebugCategory();
    @Config.LangKey(value="cfg.universaltweaks.config.masterswitches")
    @Config.Name(value="Master Switches")
    public static final MasterSwitchesCategory MASTER_SWITCHES = new MasterSwitchesCategory();

    static {
        ConfigAnytime.register(UTConfigGeneral.class);
    }

    @Mod.EventBusSubscriber(modid="universaltweaks")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("universaltweaks")) {
                ConfigManager.sync((String)"universaltweaks", (Config.Type)Config.Type.INSTANCE);
                UTObsoleteModsHandler.setHasShownObsoleteMods(false);
            }
        }
    }

    public static class MasterSwitchesCategory {
        @Config.Name(value="Master Switch: Bugfixes")
        @Config.Comment(value={"Enables the 'Bugfixes' module", "Turn off to disable all bugfix tweaks"})
        public boolean utMasterSwitchBugfixes = true;
        @Config.Name(value="Master Switch: Mod Integration")
        @Config.Comment(value={"Enables the 'Mod Integration' module", "Turn off to disable all mod integration tweaks"})
        public boolean utMasterSwitchModIntegration = true;
        @Config.Name(value="Master Switch: Tweaks")
        @Config.Comment(value={"Enables the 'Tweaks' module", "Turn off to disable all vanilla tweaks"})
        public boolean utMasterSwitchTweaks = true;
    }

    public static class DebugCategory {
        @Config.Name(value="Bypass Incompatibility Warnings")
        @Config.Comment(value={"For those who live life on the edge, may or may not include Jons"})
        public boolean utBypassIncompatibilityToggle = false;
        @Config.Name(value="Debug Logging")
        @Config.Comment(value={"Enables debug logging"})
        public boolean utDebugToggle = false;
        @Config.Name(value="Show Loading Time")
        @Config.Comment(value={"Prints the time the game needed to launch to the log"})
        public boolean utLoadingTimeToggle = true;
    }
}

