/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.config;

import com.cleanroommc.configanytime.ConfigAnytime;
import mod.acgaming.universaltweaks.bugfixes.blocks.blockoverlay.UTBlockOverlayLists;
import mod.acgaming.universaltweaks.bugfixes.entities.desync.UTEntityDesync;
import mod.acgaming.universaltweaks.core.UTLoadingPlugin;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="universaltweaks", name="Universal Tweaks - Bugfixes")
public class UTConfigBugfixes {
    @Config.LangKey(value="cfg.universaltweaks.config.blocks")
    @Config.Name(value="Blocks")
    public static final BlocksCategory BLOCKS = new BlocksCategory();
    @Config.LangKey(value="cfg.universaltweaks.config.entities")
    @Config.Name(value="Entities")
    public static final EntitiesCategory ENTITIES = new EntitiesCategory();
    @Config.LangKey(value="cfg.universaltweaks.config.misc")
    @Config.Name(value="Misc")
    public static final MiscCategory MISC = new MiscCategory();
    @Config.LangKey(value="cfg.universaltweaks.config.world")
    @Config.Name(value="World")
    public static final WorldCategory WORLD = new WorldCategory();

    static {
        ConfigAnytime.register(UTConfigBugfixes.class);
    }

    @Mod.EventBusSubscriber(modid="universaltweaks")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("universaltweaks")) {
                ConfigManager.sync((String)"universaltweaks", (Config.Type)Config.Type.INSTANCE);
                if (UTConfigBugfixes.ENTITIES.ENTITY_DESYNC.utEntityDesyncToggle) {
                    UTEntityDesync.initBlacklistedEntityEntries();
                }
                if (UTLoadingPlugin.isClient && UTConfigBugfixes.BLOCKS.BLOCK_OVERLAY.utBlockOverlayToggle) {
                    UTBlockOverlayLists.initLists();
                }
            }
        }
    }

    public static class WorldCategory {
        @Config.RequiresMcRestart
        @Config.Name(value="Chunk Saving")
        @Config.Comment(value={"Fixes loading of outdated chunks to prevent duplications, deletions and data corruption", "Incompatible with SpongeForge"})
        public boolean utChunkSavingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Frustum Culling")
        @Config.Comment(value={"Fixes invisible chunks in edge cases (small enclosed rooms at chunk borders)"})
        public boolean utFrustumCullingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Portal Location Link")
        @Config.Comment(value={"Ensures portals link to their original overworld portal if within close distance"})
        public boolean utPortalLocationLink = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Portal Traveling Dupe")
        @Config.Comment(value={"Fixes duplication issues that can occur when entities travel through portals"})
        public boolean utPortalTravelingDupeToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Village Component Parts")
        @Config.Comment(value={"Always builds village structures with biome-specific blocks", "Improves compatibility with mods such as BiomeTweaker"})
        public boolean utVillageComponentPartsToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Witch Huts")
        @Config.Comment(value={"Fixes witch hut structure data not accounting for the height it is generated at"})
        public boolean utWitchStructuresToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Tile Entity Map")
        @Config.Comment(value={"Changes the data table of tile entities to resolve issues", "HASHMAP:                   Vanilla default", "LINKED_HASHMAP:            Keeps the loading order of tile entities to prevent issues during the first ticks of chunk loading", "CONCURRENT_HASHMAP:        Allows simultaneous access to tile entities to prevent concurrent modification exceptions", "CONCURRENT_LINKED_HASHMAP: Combines LINKED_HASHMAP and CONCURRENT_HASHMAP, may have random side effects"})
        public EnumMaps utTileEntityMap = EnumMaps.LINKED_HASHMAP;

        public static enum EnumMaps {
            HASHMAP,
            LINKED_HASHMAP,
            CONCURRENT_HASHMAP,
            CONCURRENT_LINKED_HASHMAP;

        }
    }

    public static class MiscCategory {
        @Config.RequiresMcRestart
        @Config.Name(value="Accurate Smooth Lighting")
        @Config.Comment(value={"Improves the accuracy of smooth lighting by checking for suffocation and light opacity"})
        public boolean utAccurateSmoothLighting = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Crafted Item Statistics")
        @Config.Comment(value={"Fixes crafted item statistics not increasing correctly when items are crafted with shift-click or drop methods"})
        public boolean utCraftedItemStatisticsToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Depth Mask")
        @Config.Comment(value={"Fixes entity and particle rendering issues by enabling depth buffer writing", "Can cause issues with modded particles"})
        public boolean utDepthMaskToggle = false;
        @Config.Name(value="Help Command")
        @Config.Comment(value={"Replaces the help command, sorts and reports broken commands"})
        public boolean utHelpToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Locale Crash")
        @Config.Comment(value={"Prevents various crashes with Turkish locale"})
        public boolean utLocaleToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Overlay Message Fade Out")
        @Config.Comment(value={"Fixes Forge's overlay message (action bar) fade out regression"})
        public boolean utOverlayMessageFadeOut = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Particle Spawning")
        @Config.Comment(value={"Fixes various particle types not showing up on the client"})
        public boolean utParticleSpawningToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Potion Amplifier Visibility")
        @Config.Comment(value={"Fixes potion effects not displaying their level above 'IV'"})
        public boolean utPotionAmplifierVisibilityToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Spectator Menu")
        @Config.Comment(value={"Fixes the spectator menu not showing player skins"})
        public boolean utSpectatorMenuToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Packet Size")
        @Config.Comment(value={"Increases the packet size limit to account for large packets in modded environments", "Vanilla default is 0x200000", "Incompatible with SpongeForge and RandomPatches"})
        public int utPacketSize = 0x1000000;
        @Config.RequiresMcRestart
        @Config.Name(value="Cull Picked-up Items")
        @Config.Comment(value={"Fix missing face culling during item pickup particle rendering"})
        public boolean utItemPickupCulling = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Extend Item Durability Range")
        @Config.Comment(value={"Changes the durability storing to use ints instead of shorts, eliminating many issues with high-durability items (I.E. TiC tools)"})
        public boolean utExtendDurabilityCap = true;
    }

    public static class EntitiesCategory {
        @Config.LangKey(value="cfg.universaltweaks.bugfixes.entities.desync")
        @Config.Name(value="Entity Desync")
        public final EntityDesyncCategory ENTITY_DESYNC = new EntityDesyncCategory();
        @Config.LangKey(value="cfg.universaltweaks.bugfixes.entities.entitylists")
        @Config.Name(value="Entity Lists")
        public final EntityListsCategory ENTITY_LISTS = new EntityListsCategory();
        @Config.RequiresMcRestart
        @Config.Name(value="Attack Radius")
        @Config.Comment(value={"Improves the attack radius of hostile mobs by checking the line of sight with raytracing"})
        public boolean utAttackRadiusToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Block Fire")
        @Config.Comment(value={"Prevents fire projectiles burning entities when blocking with shields"})
        public boolean utBlockFireToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Boat Riding Offset")
        @Config.Comment(value={"Fixes entities glitching through the bottom of boats"})
        public boolean utBoatOffsetToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Concurrent Entity AI Tasks")
        @Config.Comment(value={"Replaces linked entity AI task sets with concurrent sets to avoid mod exception concerning entity AI", "Only enable this if you're facing concurrent modification exceptions with entity AI tasks, for example Thaumcraft's Pechs"})
        public boolean utEntityAITasksToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Death Time")
        @Config.Comment(value={"Fixes corrupted entities exceeding the allowed death time"})
        public boolean utDeathTimeToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Destroy Entity Packets")
        @Config.Comment(value={"Fixes lag caused by dead entities by sending additional packets when the player is not alive"})
        public boolean utDestroyPacketToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Disconnect Dupe")
        @Config.Comment(value={"Fixes item duplications when players are dropping items and disconnecting"})
        public boolean utDisconnectDupeToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Dimension Change Player States")
        @Config.Comment(value={"Fixes missing player states when changing dimensions by sending additional packets"})
        public boolean utDimensionChangeToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Double Consumption")
        @Config.Comment(value={"Fixes consuming an item having a chance of also consuming a second item without any animation, like the infamous double eating food bug"})
        public boolean utDoubleConsumptionToggle = true;
        @Config.Name(value="Donkey/Mule Dupe")
        @Config.Comment(value={"Fixes a duplication exploit connected to the inventories of donkeys and mules"})
        public boolean utDonkeyMuleDupeToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Elytra Deployment & Landing")
        @Config.Comment(value={"Relocate elytra deployment and landing to client side to prevent issues with high latencies"})
        public boolean utElytraDeploymentLandingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Fixes Invisible Player when Flying with Elytra")
        @Config.Comment(value={"Fixes the player model occasionally disappearing when flying with elytra in a straight line in third-person mode", "Incompatible with OpenModsLib"})
        public boolean utFixInvisiblePlayerModelWithElytra = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Entity Bounding Box")
        @Config.Comment(value={"Saves entity bounding boxes to tags to prevent breakouts and suffocation"})
        public boolean utEntityAABBToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Entity ID")
        @Config.Comment(value={"Fixes non-functional elytra firework boosting and guardian targeting if the entity ID is 0"})
        public boolean utEntityIDToggle = true;
        @Config.Name(value="Entity NaN Values")
        @Config.Comment(value={"Prevents corruption of entities caused by invalid health or damage values"})
        public boolean utEntityNaNToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Entity Suffocation")
        @Config.Comment(value={"Pushes entities out of blocks when growing up to prevent suffocation"})
        public boolean utEntitySuffocationToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Entity Tracker")
        @Config.Comment(value={"Fixes entity tracker to prevent client-sided desyncs when teleporting or changing dimensions", "Incompatible with SpongeForge"})
        public boolean utEntityTrackerToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Entity UUID")
        @Config.Comment(value={"Changes UUIDs of loaded entities in case their UUIDs are already assigned (and removes log spam)"})
        public boolean utEntityUUIDToggle = true;
        @Config.Name(value="Horse Falling")
        @Config.Comment(value={"Modifies falling logic of horses, listening to LivingFallEvent and taking jump boost into account"})
        public boolean utHorseFallingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Max Player Health")
        @Config.Comment(value={"Corrects maximum player health on joining by setting the last saved health value"})
        public boolean utMaxHealthToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Minecart AI")
        @Config.Comment(value={"Fixes non-player entities being able to control minecarts"})
        public boolean utMinecartAIToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Mount Desync")
        @Config.Comment(value={"Fixes mounts and boats sometimes disappearing after dismounting"})
        public boolean utMountDesyncToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Player Saturation")
        @Config.Comment(value={"Fixes saturation depleting in peaceful mode"})
        public boolean utExhaustionToggle = true;
        @Config.Name(value="Shear Mooshroom Dupe")
        @Config.Comment(value={"Fixes a duplication exploit connected to shearing mooshrooms"})
        public boolean utShearMooshroomDupeToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Skeleton Aim")
        @Config.Comment(value={"Fixes skeletons not looking at their targets when strafing"})
        public boolean utSkeletonAimToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Untipped Arrow Particles")
        @Config.Comment(value={"Fixes untipped arrows emitting blue tipped arrow particles upon reloading a world"})
        public boolean utUntippedArrowParticlesToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Villager Mantle Hoods")
        @Config.Comment(value={"Returns missing hoods to villager mantles"})
        public boolean utVillagerMantleToggle = false;

        public static class EntityListsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Chunk Updates")
            @Config.Comment(value={"Fixes chunk entity lists often not getting updated correctly"})
            public boolean utChunkUpdatesToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="World Additions")
            @Config.Comment(value={"Fixes client-side memory leak where some entity ids are not set before being added to the world's entity list"})
            public boolean utWorldAdditionsToggle = true;
        }

        public static class EntityDesyncCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Entity Desync Toggle")
            @Config.Comment(value={"Fixes entity motion desyncs most notable with arrows and thrown items"})
            public boolean utEntityDesyncToggle = true;
            @Config.Name(value="[2] Entity Blacklist")
            @Config.Comment(value={"Syntax:  modid:entity", "Example: minecraft:minecart"})
            public String[] utEntityDesyncBlacklist = new String[]{"minecraft:minecart", "pixelmon:empty_pokeball", "pixelmon:occupied_pokeball"};
        }
    }

    public static class BlocksCategory {
        @Config.LangKey(value="cfg.universaltweaks.bugfixes.blocks.blockoverlay")
        @Config.Name(value="Block Overlay")
        public final BlockOverlayCategory BLOCK_OVERLAY = new BlockOverlayCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.miningglitch")
        @Config.Name(value="Mining Glitch")
        public final MiningGlitchCategory MINING_GLITCH = new MiningGlitchCategory();
        @Config.RequiresMcRestart
        @Config.Name(value="Banner Bounding Box")
        @Config.Comment(value={"Fixes rendering issues with banners by correctly sizing their render bounding boxes", "Incompatible with RenderLib"})
        public boolean utBannerBoundingBoxToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Comparator Timing")
        @Config.Comment(value={"Fixes inconsistent delays of comparators to prevent redstone timing issues"})
        public boolean utComparatorTimingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Falling Block Entity Damage")
        @Config.Comment(value={"Only damage living entities hit by falling blocks, prevents killing items and XP"})
        public boolean utFallingBlockDamageToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Hopper Bounding Box")
        @Config.Comment(value={"Slims down the hopper bounding box for easier access of nearby blocks"})
        public boolean utDietHopperToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Hopper Insert Safety Check")
        @Config.Comment(value={"Prevents crashes when the destination tile entity becomes unavailable during the item insert process", "Mainly utilized to suppress edge case symptoms with Thaumcraft's Thaumatorium"})
        public boolean utHopperInsertToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Item Frame Void")
        @Config.Comment(value={"Prevents voiding held items when right + left clicking on an item frame simultaneously"})
        public boolean utItemFrameVoidToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Ladder Flying Slowdown")
        @Config.Comment(value={"Disables climbing movement when flying"})
        public boolean utLadderFlyingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Piston Progress")
        @Config.Comment(value={"Properly saves the last state of pistons to tags"})
        public boolean utPistonTileToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Piston Retraction")
        @Config.Comment(value={"Improves retraction behavior on double piston extenders"})
        public boolean utPistonRetractionToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Sleep Resets Weather")
        @Config.Comment(value={"Fixes sleeping always resetting rain and thunder times"})
        public boolean utSleepResetsWeatherToggle = true;

        public static class MiningGlitchCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Mining Glitch Toggle")
            @Config.Comment(value={"Prevents ghost blocks by sending additional movement packets"})
            public boolean utMiningGlitchToggle = true;
            @Config.Name(value="[2] Maximum Movement Packets")
            @Config.Comment(value={"Defines the maximum number of movement packets that can be sent per tick", "Vanilla default is 5"})
            public int utMiningGlitchPackets = 10;
        }

        public static class BlockOverlayCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Block Overlay Toggle")
            @Config.Comment(value={"Fixes x-ray when standing in non-suffocating blocks"})
            public boolean utBlockOverlayToggle = true;
            @Config.Name(value="[2] Blacklist")
            @Config.Comment(value={"Excludes blocks from the block overlay bugfix", "Syntax: modid:block"})
            public String[] utBlockOverlayBlacklist = new String[0];
            @Config.Name(value="[3] Whitelist")
            @Config.Comment(value={"Includes blocks in the block overlay bugfix", "Syntax: modid:block"})
            public String[] utBlockOverlayWhitelist = new String[0];
        }
    }
}

