/*
 * Decompiled with CFR 0.152.
 */
package wanion.biggercraftingtables.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import wanion.biggercraftingtables.recipe.giant.GiantRecipeRegistry;
import wanion.biggercraftingtables.recipe.giant.ShapedGiantRecipe;
import wanion.biggercraftingtables.recipe.giant.ShapelessGiantRecipe;
import wanion.lib.common.CraftTweakerHelper;
import wanion.lib.common.Util;
import wanion.lib.recipe.RecipeHelper;

@ZenRegister
@ZenClass(value="mods.biggercraftingtables.Giant")
public final class GiantCrafting {
    private GiantCrafting() {
    }

    @ZenMethod
    public static void addShaped(@Nonnull IItemStack output, @Nonnull IIngredient[][] inputs) {
        int height = inputs.length;
        int width = 0;
        for (IIngredient[] row : inputs) {
            if (width >= row.length) continue;
            width = row.length;
        }
        Object[][] input = new Object[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                input[y][x] = CraftTweakerHelper.toActualObject((IIngredient)inputs[y][x]);
            }
        }
        CraftTweakerAPI.apply((IAction)new Add(new ShapedGiantRecipe(CraftTweakerHelper.toStack((IItemStack)output), RecipeHelper.rawShapeToShape((Object[])Util.treeDimArrayToTwoDimArray((Object[][])input)).actualShape)));
    }

    @ZenMethod
    public static void addShapeless(@Nonnull IItemStack output, @Nonnull IIngredient[] inputs) {
        CraftTweakerAPI.apply((IAction)new Add(new ShapelessGiantRecipe(CraftTweakerHelper.toStack((IItemStack)output), CraftTweakerHelper.toObjects((IIngredient[])inputs))));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack((IItemStack)target)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack itemStackToRemove;
        private final GiantRecipeRegistry.IGiantRecipe recipe;

        private Remove(@Nonnull ItemStack itemStackToRemove) {
            this.itemStackToRemove = itemStackToRemove;
            GiantRecipeRegistry.IGiantRecipe recipe = null;
            block0: for (List giantRecipeList : GiantRecipeRegistry.INSTANCE.recipes.values()) {
                if (recipe != null) break;
                if (giantRecipeList == null) continue;
                for (GiantRecipeRegistry.IGiantRecipe giantRecipe : giantRecipeList) {
                    if (!giantRecipe.getOutput().func_77969_a(itemStackToRemove)) continue;
                    recipe = giantRecipe;
                    continue block0;
                }
            }
            this.recipe = recipe;
        }

        public void apply() {
            GiantRecipeRegistry.INSTANCE.removeRecipe(this.recipe);
        }

        public String describe() {
            return "Removing GiantRecipe for " + this.itemStackToRemove.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final GiantRecipeRegistry.IGiantRecipe recipe;

        public Add(@Nonnull GiantRecipeRegistry.IGiantRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            GiantRecipeRegistry.INSTANCE.addRecipe(this.recipe);
        }

        public String describe() {
            return "Adding GiantRecipe for " + this.recipe.getOutput().func_82833_r();
        }
    }
}

