/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktShootEntity
implements IMessage,
IMessageHandler<PktShootEntity, IMessage> {
    private static final Random rand = new Random();
    private int entityId;
    private Vector3 motionVector;
    private boolean hasEffect = false;
    private double effectLength = 0.0;

    public PktShootEntity() {
    }

    public PktShootEntity(int entityId, Vector3 motionVector) {
        this.entityId = entityId;
        this.motionVector = motionVector;
    }

    public PktShootEntity setEffectLength(double length) {
        this.hasEffect = true;
        this.effectLength = length;
        return this;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.motionVector = new Vector3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.hasEffect = buf.readBoolean();
        if (this.hasEffect) {
            this.effectLength = buf.readDouble();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.motionVector.getX());
        buf.writeDouble(this.motionVector.getY());
        buf.writeDouble(this.motionVector.getZ());
        buf.writeBoolean(this.hasEffect);
        if (this.hasEffect) {
            buf.writeDouble(this.effectLength);
        }
    }

    public IMessage onMessage(PktShootEntity message, MessageContext ctx) {
        AstralSorcery.proxy.scheduleClientside(() -> PktShootEntity.shootEntity(message));
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static void shootEntity(PktShootEntity pkt) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(pkt.entityId);
        if (entity != null) {
            entity.field_70159_w = pkt.motionVector.getX();
            entity.field_70181_x = pkt.motionVector.getY();
            entity.field_70179_y = pkt.motionVector.getZ();
            if (pkt.hasEffect) {
                Vector3 origin = new Vector3(entity.field_70165_t + (double)(entity.field_70130_N / 2.0f), entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v + (double)(entity.field_70130_N / 2.0f));
                Vector3 look = new Vector3(entity.func_70040_Z()).normalize().multiply(pkt.effectLength * 18.0);
                Vector3 motionReverse = look.clone().normalize().multiply(-0.4 * pkt.effectLength);
                Vector3 perp = look.clone().perpendicular();
                for (int i = 0; i < 500 + rand.nextInt(80); ++i) {
                    Vector3 at = look.clone().multiply(0.2 + (double)rand.nextFloat() * 2.5).add(perp.clone().rotate(rand.nextFloat() * 360.0f, look).multiply((double)rand.nextFloat() * 1.6)).add(origin);
                    EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                    p.scale(0.35f + rand.nextFloat() * 0.2f).setMaxAge(10 + rand.nextInt(10));
                    p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).setAlphaMultiplier(1.0f);
                    p.gravity(0.004);
                    if (rand.nextBoolean()) {
                        p.setColor(Color.WHITE);
                        p.scale(0.1f + rand.nextFloat() * 0.05f);
                    } else {
                        p.setColor(BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL.displayColor);
                    }
                    if (rand.nextInt(4) != 0) {
                        p.motion(motionReverse.getX(), motionReverse.getY(), motionReverse.getZ());
                        continue;
                    }
                    p.motion(0.0, 0.0, 0.0);
                }
            }
        }
    }
}

