/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.knowledge;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.data.KnowledgeFragmentData;
import hellfirepvp.astralsorcery.client.data.PersistentDataManager;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.MoonPhase;
import hellfirepvp.astralsorcery.common.data.fragment.KnowledgeFragment;
import hellfirepvp.astralsorcery.common.entities.EntityItemHighlighted;
import hellfirepvp.astralsorcery.common.item.base.ItemHighlighted;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktRemoveKnowledgeFragment;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemKnowledgeFragment
extends Item
implements ItemHighlighted {
    public ItemKnowledgeFragment() {
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return RegistryItems.rarityRelic;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (ItemKnowledgeFragment.getSeed(stack).isPresent()) {
            if (ItemKnowledgeFragment.hasConstellationInformation(stack)) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"misc.fragment.constellation.desc.1", (Object[])new Object[0]));
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"misc.fragment.constellation.desc.2", (Object[])new Object[0]));
            } else if (ItemKnowledgeFragment.resolveFragment(stack) != null) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"misc.fragment.content.desc.1", (Object[])new Object[0]));
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"misc.fragment.content.desc.2", (Object[])new Object[0]));
            } else {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"misc.fragment.content.empty", (Object[])new Object[0]));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemKnowledgeFragment && !ItemKnowledgeFragment.getSeed(stack).isPresent()) {
            stack.func_190920_e(0);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            if (ItemKnowledgeFragment.hasConstellationInformation(stack)) {
                player.openGui((Object)AstralSorcery.instance, CommonProxy.EnumGuiId.KNOWLEDGE_CONSTELLATION.ordinal(), world, 0, 0, 0);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
            }
            KnowledgeFragment frag = ItemKnowledgeFragment.resolveFragment(stack);
            if (frag != null) {
                ItemKnowledgeFragment.clearFragment(player, frag);
                KnowledgeFragmentData dat = (KnowledgeFragmentData)PersistentDataManager.INSTANCE.getData(PersistentDataManager.PersistentKey.KNOWLEDGE_FRAGMENTS);
                if (dat.addFragment(frag)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + I18n.func_135052_a((String)"misc.fragment.added", (Object[])new Object[]{frag.getLocalizedIndexName()})));
                }
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        ItemStack stack;
        if (!entityItem.field_70170_p.field_72995_K && !(stack = entityItem.func_92059_d()).func_190926_b() && stack.func_77973_b() instanceof ItemKnowledgeFragment && !ItemKnowledgeFragment.getSeed(stack).isPresent()) {
            entityItem.func_70106_y();
            stack.func_190920_e(0);
            entityItem.func_92058_a(stack);
        }
        return false;
    }

    static void generateSeed(EntityPlayer player, ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemKnowledgeFragment) {
            long baseRand = ((long)(player.func_145782_y() << 6) | System.currentTimeMillis() & 0xDFL) << 16 | player.func_130014_f_().func_82737_E();
            Random r = new Random(baseRand);
            r.nextLong();
            ItemKnowledgeFragment.setSeed(stack, r.nextLong());
        }
    }

    @Override
    public Color getHightlightColor(ItemStack stack) {
        return new Color(13560575);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity entity, ItemStack itemstack) {
        EntityItemHighlighted ei = new EntityItemHighlighted(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemstack);
        ei.func_174869_p();
        ei.field_70159_w = entity.field_70159_w;
        ei.field_70181_x = entity.field_70181_x;
        ei.field_70179_y = entity.field_70179_y;
        if (entity instanceof EntityItem) {
            ei.func_145799_b(((EntityItem)entity).func_145800_j());
            ei.func_145797_a(((EntityItem)entity).func_145798_i());
        }
        return ei;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static Tuple<IConstellation, List<MoonPhase>> getConstellationInformation(ItemStack stack) {
        Optional<Long> seedOpt;
        KnowledgeFragment frag = ItemKnowledgeFragment.resolveFragment(stack);
        if (frag != null && (seedOpt = ItemKnowledgeFragment.getSeed(stack)).isPresent()) {
            long seed = seedOpt.get();
            IConstellation cst = frag.getDiscoverConstellation(seed);
            List<MoonPhase> phases = frag.getShowupPhases(seed);
            if (cst != null && !phases.isEmpty()) {
                return new Tuple<IConstellation, List<MoonPhase>>(cst, phases);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasConstellationInformation(ItemStack stack) {
        return ItemKnowledgeFragment.getConstellationInformation(stack) != null;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static KnowledgeFragment resolveFragment(ItemStack stack) {
        Optional<Long> seedOpt = ItemKnowledgeFragment.getSeed(stack);
        if (!seedOpt.isPresent()) {
            return null;
        }
        Random sRand = new Random(seedOpt.get());
        KnowledgeFragmentData dat = (KnowledgeFragmentData)PersistentDataManager.INSTANCE.getData(PersistentDataManager.PersistentKey.KNOWLEDGE_FRAGMENTS);
        List<KnowledgeFragment> all = dat.getDiscoverableFragments();
        all.removeIf(f -> !f.isFullyPresent());
        if (all.isEmpty()) {
            return null;
        }
        int index = sRand.nextInt(all.size());
        return all.get(index);
    }

    @SideOnly(value=Side.CLIENT)
    public static List<ItemStack> gatherFragments(EntityPlayer player) {
        Collection<ItemStack> fragItems = ItemUtils.findItemsInInventory((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), new ItemStack((Item)ItemsAS.knowledgeFragment), false);
        LinkedList<ItemStack> frags = new LinkedList<ItemStack>();
        for (ItemStack stack : fragItems) {
            KnowledgeFragment fr;
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemKnowledgeFragment) || (fr = ItemKnowledgeFragment.resolveFragment(stack)) == null) continue;
            frags.add(stack);
        }
        return frags;
    }

    @SideOnly(value=Side.CLIENT)
    public static void clearFragment(EntityPlayer player, KnowledgeFragment frag) {
        Map<Integer, ItemStack> fragItems = ItemUtils.findItemsIndexedInInventory((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), new ItemStack((Item)ItemsAS.knowledgeFragment), false);
        for (Map.Entry<Integer, ItemStack> entry : fragItems.entrySet()) {
            KnowledgeFragment fr;
            ItemStack stack = entry.getValue();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemKnowledgeFragment) || (fr = ItemKnowledgeFragment.resolveFragment(stack)) == null || !fr.equals(frag)) continue;
            PacketChannel.CHANNEL.sendToServer((IMessage)new PktRemoveKnowledgeFragment(entry.getKey()));
            player.field_71071_by.func_70299_a(entry.getKey().intValue(), ItemStack.field_190927_a);
            break;
        }
    }

    public static void setSeed(ItemStack stack, long seed) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemKnowledgeFragment)) {
            return;
        }
        NBTHelper.getPersistentData(stack).func_74772_a("seed", seed);
    }

    public static Optional<Long> getSeed(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemKnowledgeFragment)) {
            return Optional.empty();
        }
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        if (!cmp.func_74764_b("seed")) {
            return Optional.empty();
        }
        return Optional.of(cmp.func_74763_f("seed"));
    }
}

