/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.crystal.base;

import hellfirepvp.astralsorcery.common.entities.EntityCrystal;
import hellfirepvp.astralsorcery.common.item.base.ItemHighlighted;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalPropertyItem;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCelestialCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.ItemTunedCelestialCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemTunedCrystalBase;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemRockCrystalBase
extends Item
implements ItemHighlighted,
CrystalPropertyItem {
    private static Random rand = new Random();

    public ItemRockCrystalBase() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        CrystalProperties prop = CrystalProperties.getCrystalProperties(stack);
        if (prop == null) {
            Item i = stack.func_77973_b();
            if (i instanceof ItemCelestialCrystal || i instanceof ItemTunedCelestialCrystal) {
                CrystalProperties.applyCrystalProperties(stack, CrystalProperties.createRandomCelestial());
            } else {
                CrystalProperties.applyCrystalProperties(stack, CrystalProperties.createRandomRock());
            }
        } else if (prop.getFracturation() >= 100) {
            stack.func_190920_e(0);
            entityIn.func_184185_a(SoundEvents.field_187635_cQ, 0.5f, rand.nextFloat() * 0.2f + 0.8f);
        }
    }

    @Override
    public Color getHightlightColor(ItemStack stack) {
        return Color.WHITE;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        EntityCrystal crystal = new EntityCrystal(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        crystal.func_174869_p();
        crystal.func_174873_u();
        crystal.field_70159_w = location.field_70159_w;
        crystal.field_70181_x = location.field_70181_x;
        crystal.field_70179_y = location.field_70179_y;
        if (location instanceof EntityItem) {
            crystal.func_145799_b(((EntityItem)location).func_145800_j());
            crystal.func_145797_a(((EntityItem)location).func_145798_i());
        }
        return crystal;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.addCrystalPropertyToolTip(stack, tooltip);
    }

    @Override
    public int getMaxSize(ItemStack stack) {
        return 400;
    }

    @Override
    @Nullable
    public CrystalProperties provideCurrentPropertiesOrNull(ItemStack stack) {
        return CrystalProperties.getCrystalProperties(stack);
    }

    @SideOnly(value=Side.CLIENT)
    protected Optional<Boolean> addCrystalPropertyToolTip(ItemStack stack, List<String> tooltip) {
        return CrystalProperties.addPropertyTooltip(CrystalProperties.getCrystalProperties(stack), tooltip, this.getMaxSize(stack));
    }

    public abstract ItemTunedCrystalBase getTunedItemVariant();

    public static ItemStack createMaxBaseCrystal() {
        ItemStack crystal = new ItemStack((Item)ItemsAS.rockCrystal);
        CrystalProperties.applyCrystalProperties(crystal, CrystalProperties.getMaxRockProperties());
        return crystal;
    }

    public static ItemStack createMaxCelestialCrystal() {
        ItemStack crystal = new ItemStack((Item)ItemsAS.celestialCrystal);
        CrystalProperties.applyCrystalProperties(crystal, CrystalProperties.getMaxCelestialProperties());
        return crystal;
    }

    public static ItemStack createRandomBaseCrystal() {
        ItemStack crystal = new ItemStack((Item)ItemsAS.rockCrystal);
        CrystalProperties.applyCrystalProperties(crystal, CrystalProperties.createRandomRock());
        return crystal;
    }

    public static ItemStack createRandomCelestialCrystal() {
        ItemStack crystal = new ItemStack((Item)ItemsAS.celestialCrystal);
        CrystalProperties.applyCrystalProperties(crystal, CrystalProperties.createRandomCelestial());
        return crystal;
    }
}

