/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entities;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.entities.EntityTechnicalAmbient;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityNocturnalSpark
extends EntityThrowable
implements EntityTechnicalAmbient {
    private static final AxisAlignedBB NO_DUPE_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186662_g(15.0);
    private static final DataParameter<Boolean> SPAWNING = EntityDataManager.func_187226_a(EntityNocturnalSpark.class, (DataSerializer)DataSerializers.field_187198_h);
    private int ticksSpawning = 0;

    public EntityNocturnalSpark(World worldIn) {
        super(worldIn);
    }

    public EntityNocturnalSpark(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityNocturnalSpark(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
        this.func_184538_a((Entity)throwerIn, throwerIn.field_70125_A, throwerIn.field_70177_z, 0.0f, 0.7f, 0.9f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPAWNING, (Object)false);
    }

    public void setSpawning() {
        this.field_70180_af.func_187227_b(SPAWNING, (Object)true);
    }

    public boolean isSpawning() {
        return (Boolean)this.field_70180_af.func_187225_a(SPAWNING);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70128_L) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.playEffects();
        } else if (this.isSpawning()) {
            ++this.ticksSpawning;
            this.spawnCycle();
            if (this.ticksSpawning > 200) {
                this.func_70106_y();
            }
        }
    }

    private void spawnCycle() {
        List sparks = this.field_70170_p.func_72872_a(EntityNocturnalSpark.class, NO_DUPE_BOX.func_186670_a(this.func_180425_c()));
        for (EntityNocturnalSpark spark : sparks) {
            if (this.equals(spark) || spark.field_70128_L || !spark.isSpawning()) continue;
            spark.func_70106_y();
        }
        if (this.field_70146_Z.nextInt(12) == 0 && this.field_70170_p instanceof WorldServer) {
            try {
                boolean canAtAll;
                BlockPos pos = this.func_180425_c().func_177984_a();
                pos.func_177982_a(this.field_70146_Z.nextInt(2) - this.field_70146_Z.nextInt(2), this.field_70146_Z.nextInt(1) - this.field_70146_Z.nextInt(1), this.field_70146_Z.nextInt(2) - this.field_70146_Z.nextInt(2));
                List list = ((WorldServer)this.field_70170_p).func_72863_F().func_177458_a(EnumCreatureType.MONSTER, pos);
                list = ForgeEventFactory.getPotentialSpawns((WorldServer)((WorldServer)this.field_70170_p), (EnumCreatureType)EnumCreatureType.MONSTER, (BlockPos)pos, (List)list);
                if (list == null || list.isEmpty()) {
                    return;
                }
                Biome.SpawnListEntry entry = (Biome.SpawnListEntry)list.get(this.field_70146_Z.nextInt(list.size()));
                if (this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && EntityCreeper.class.isAssignableFrom(entry.field_76300_b)) {
                    return;
                }
                Block down = this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c();
                boolean bl = canAtAll = down != Blocks.field_180401_cv && down != Blocks.field_150357_h;
                if (canAtAll && WorldEntitySpawner.func_185331_a((IBlockState)this.field_70170_p.func_180495_p(this.func_180425_c())) && WorldEntitySpawner.func_185331_a((IBlockState)this.field_70170_p.func_180495_p(pos))) {
                    EntityLiving entity = entry.newInstance(this.field_70170_p);
                    entity.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                    if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entity, (World)this.field_70170_p, (float)((float)pos.func_177958_n() + 0.5f), (float)pos.func_177956_o(), (float)((float)pos.func_177952_p() + 0.5f))) {
                        entity.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), null);
                    }
                    if (entity.func_70058_J()) {
                        this.field_70170_p.func_72838_d((Entity)entity);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playEffects() {
        if (this.isSpawning()) {
            for (int i = 0; i < 15; ++i) {
                Vector3 thisPos = Vector3.atEntityCorner((Entity)this).addY(1.0);
                MiscUtils.applyRandomOffset(thisPos, this.field_70146_Z, 2 + this.field_70146_Z.nextInt(4));
                EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(thisPos.getX(), thisPos.getY(), thisPos.getZ()).scale(4.0f).setColor(Color.BLACK).enableAlphaFade(EntityComplexFX.AlphaFunction.PYRAMID).gravity(0.004).setAlphaMultiplier(0.7f);
                if (this.field_70146_Z.nextInt(5) == 0) {
                    this.randomizeColor(particle);
                }
                if (this.field_70146_Z.nextInt(3) != 0) continue;
                Vector3 target = Vector3.atEntityCorner((Entity)this);
                MiscUtils.applyRandomOffset(target, this.field_70146_Z, 4.0f);
                AstralSorcery.proxy.fireLightning(this.field_70170_p, Vector3.atEntityCorner((Entity)this), target, Color.BLACK);
            }
        } else {
            EntityFXFacingParticle particle;
            for (int i = 0; i < 6; ++i) {
                particle = EffectHelper.genericFlareParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                particle.motion(0.04f - this.field_70146_Z.nextFloat() * 0.08f, 0.04f - this.field_70146_Z.nextFloat() * 0.08f, 0.04f - this.field_70146_Z.nextFloat() * 0.08f).scale(0.25f);
                this.randomizeColor(particle);
            }
            particle = EffectHelper.genericFlareParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            particle.scale(0.6f);
            this.randomizeColor(particle);
            particle = EffectHelper.genericFlareParticle(this.field_70165_t + this.field_70159_w / 2.0, this.field_70163_u + this.field_70181_x / 2.0, this.field_70161_v + this.field_70179_y / 2.0);
            particle.scale(0.6f);
            this.randomizeColor(particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void randomizeColor(EntityFXFacingParticle particle) {
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                particle.setColor(Color.BLACK);
                break;
            }
            case 1: {
                particle.setColor(new Color(5112173));
                break;
            }
            case 2: {
                particle.setColor(new Color(791926));
                break;
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (RayTraceResult.Type.ENTITY.equals((Object)result.field_72313_a)) {
            return;
        }
        Vec3d hit = result.field_72307_f;
        this.setSpawning();
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70165_t = hit.field_72450_a;
        this.field_70163_u = hit.field_72448_b;
        this.field_70161_v = hit.field_72449_c;
    }
}

