/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.amulet.registry;

import hellfirepvp.astralsorcery.common.data.config.ConfigDataAdapter;
import hellfirepvp.astralsorcery.common.enchantment.amulet.registry.WeightedAmuletEnchantment;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AmuletEnchantmentRegistry
implements ConfigDataAdapter<WeightedAmuletEnchantment> {
    private static final Random rand = new Random();
    public static final AmuletEnchantmentRegistry INSTANCE = new AmuletEnchantmentRegistry();
    private static List<WeightedAmuletEnchantment> possibleEnchants = new LinkedList<WeightedAmuletEnchantment>();

    private AmuletEnchantmentRegistry() {
    }

    @Override
    public Iterable<WeightedAmuletEnchantment> getDefaultDataSets() {
        LinkedList<WeightedAmuletEnchantment> enchantments = new LinkedList<WeightedAmuletEnchantment>();
        for (Enchantment e : ForgeRegistries.ENCHANTMENTS.getValues()) {
            if (e.func_190936_d()) continue;
            Enchantment.Rarity rarity = e.func_77324_c();
            enchantments.add(new WeightedAmuletEnchantment(e, rarity == null ? 5 : rarity.func_185270_a()));
        }
        return enchantments;
    }

    @Nullable
    public static Enchantment getRandomEnchant() {
        if (possibleEnchants.isEmpty()) {
            return null;
        }
        return ((WeightedAmuletEnchantment)WeightedRandom.func_76271_a((Random)rand, possibleEnchants)).getEnchantment();
    }

    public static boolean canBeInfluenced(Enchantment ench) {
        for (WeightedAmuletEnchantment e : possibleEnchants) {
            if (!e.getEnchantment().equals(ench)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConfigDataAdapter.LoadPhase getLoadPhase() {
        return ConfigDataAdapter.LoadPhase.INIT;
    }

    @Override
    public String getDataFileName() {
        return "amulet_enchantments";
    }

    @Override
    public String getDescription() {
        return "Defines a whitelist of which enchantments can be rolled and buffed by the enchantment-amulet. The higher the weight, the more likely that roll is selected.Format: <enchantment-registry-name>:<weight>";
    }

    @Override
    @Nullable
    public Optional<WeightedAmuletEnchantment> appendDataSet(String str) {
        WeightedAmuletEnchantment ench = WeightedAmuletEnchantment.deserialize(str);
        if (ench == null) {
            return Optional.empty();
        }
        possibleEnchants.add(ench);
        return Optional.of(ench);
    }

    @Override
    public void resetRegistry() {
        possibleEnchants.clear();
    }
}

