/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data;

import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.flare.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.data.AbstractData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;

public class DataPatreonFlares
extends AbstractData {
    private Map<UUID, Map<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity>> patreonFlaresClient = new HashMap<UUID, Map<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity>>();
    private Map<UUID, Map<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity>> patreonFlaresServer = new HashMap<UUID, Map<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity>>();
    private List<UUID> flareAdditions = new LinkedList<UUID>();
    private List<UUID> flareRemovals = new LinkedList<UUID>();
    private NBTTagCompound clientReadBuffer = new NBTTagCompound();

    @Nonnull
    public Collection<UUID> getOwners(Side side) {
        if (side == Side.CLIENT) {
            return this.patreonFlaresClient.keySet();
        }
        return this.patreonFlaresServer.keySet();
    }

    @Nonnull
    public Map<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity> getEntities(Side side, UUID uuid) {
        if (side == Side.CLIENT) {
            return this.patreonFlaresClient.getOrDefault(uuid, Collections.emptyMap());
        }
        return this.patreonFlaresServer.getOrDefault(uuid, Collections.emptyMap());
    }

    public Collection<Collection<PatreonPartialEntity>> getEntities(Side side) {
        return side == Side.CLIENT ? (Collection)this.patreonFlaresClient.values().stream().map(Map::values).collect(Collectors.toList()) : (Collection)this.patreonFlaresServer.values().stream().map(Map::values).collect(Collectors.toList());
    }

    public PatreonPartialEntity createEntity(EntityPlayer player, PatreonEffectHelper.PatreonEffect value) {
        UUID owner = player.func_110124_au();
        PatreonPartialEntity entity = value.createEntity(owner);
        entity.setPositionNear(player);
        this.patreonFlaresServer.computeIfAbsent(owner, o -> new HashMap()).put(value, entity);
        this.flareRemovals.remove(owner);
        if (!this.flareAdditions.contains(owner)) {
            this.flareAdditions.add(owner);
        }
        this.markDirty();
        return entity;
    }

    public void updateEntity(PatreonPartialEntity flare) {
        UUID owner = flare.getOwnerUUID();
        this.flareRemovals.remove(owner);
        if (!this.flareAdditions.contains(owner)) {
            this.flareAdditions.add(owner);
        }
        this.markDirty();
    }

    public void destroyEntity(PatreonPartialEntity flare) {
        UUID owner = flare.getOwnerUUID();
        this.flareAdditions.remove(owner);
        if (!this.flareRemovals.contains(owner)) {
            this.flareRemovals.add(owner);
        }
        this.markDirty();
        flare.setRemoved(true);
    }

    public void cleanUp(Side side) {
        if (side == Side.CLIENT) {
            this.patreonFlaresClient.clear();
            this.clientReadBuffer = new NBTTagCompound();
        } else {
            this.patreonFlaresServer.clear();
            this.flareRemovals.clear();
            this.flareAdditions.clear();
        }
    }

    @Override
    public void writeAllDataToPacket(NBTTagCompound compound) {
        NBTTagList entries = new NBTTagList();
        for (Map.Entry<UUID, Map<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity>> flares : this.patreonFlaresServer.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_186854_a("owner", flares.getKey());
            NBTTagList flareList = new NBTTagList();
            for (Map.Entry<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity> flareEntry : flares.getValue().entrySet()) {
                NBTTagCompound containerTag = new NBTTagCompound();
                containerTag.func_186854_a("id", flareEntry.getKey().getId());
                NBTTagCompound flareTag = new NBTTagCompound();
                flareEntry.getValue().writeToNBT(flareTag);
                containerTag.func_74782_a("data", (NBTBase)flareTag);
                flareList.func_74742_a((NBTBase)containerTag);
            }
            tag.func_74782_a("flareList", (NBTBase)flareList);
            entries.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("flareAdditions", (NBTBase)entries);
        compound.func_74782_a("flareRemovals", (NBTBase)new NBTTagList());
    }

    @Override
    public void writeToPacket(NBTTagCompound compound) {
        NBTTagList additions = new NBTTagList();
        for (UUID added : this.flareAdditions) {
            NBTTagCompound tag = new NBTTagCompound();
            Map<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity> flares = this.patreonFlaresServer.get(added);
            if (flares == null) continue;
            tag.func_186854_a("owner", added);
            NBTTagList flareList = new NBTTagList();
            for (Map.Entry<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity> flareEntry : flares.entrySet()) {
                NBTTagCompound containerTag = new NBTTagCompound();
                containerTag.func_186854_a("id", flareEntry.getKey().getId());
                NBTTagCompound flareTag = new NBTTagCompound();
                flareEntry.getValue().writeToNBT(flareTag);
                containerTag.func_74782_a("data", (NBTBase)flareTag);
                flareList.func_74742_a((NBTBase)containerTag);
            }
            tag.func_74782_a("flareList", (NBTBase)flareList);
            additions.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("flareAdditions", (NBTBase)additions);
        NBTTagList removals = new NBTTagList();
        for (UUID added : this.flareRemovals) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_186854_a("owner", added);
            removals.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("flareRemovals", (NBTBase)removals);
    }

    @Override
    public void readRawFromPacket(NBTTagCompound compound) {
        this.clientReadBuffer = compound;
    }

    @Override
    public void handleIncomingData(AbstractData serverData) {
        if (serverData == null || !(serverData instanceof DataPatreonFlares)) {
            return;
        }
        NBTTagList add = ((DataPatreonFlares)serverData).clientReadBuffer.func_150295_c("flareAdditions", 10);
        for (int i = 0; i < add.func_74745_c(); ++i) {
            NBTTagCompound cmp = add.func_150305_b(i);
            UUID owner = cmp.func_186857_a("owner");
            NBTTagList flareList = cmp.func_150295_c("flareList", 10);
            for (int j = 0; j < flareList.func_74745_c(); ++j) {
                NBTTagCompound containerTag = flareList.func_150305_b(j);
                UUID effectId = containerTag.func_186857_a("id");
                NBTTagCompound flareTag = containerTag.func_74775_l("data");
                PatreonEffectHelper.PatreonEffect pe = PatreonEffectHelper.getPatreonEffects(Side.SERVER, owner).stream().filter(p -> p.getId().equals(effectId) && p.hasPartialEntity()).findFirst().orElse(null);
                if (pe == null) continue;
                PatreonPartialEntity entity = (PatreonPartialEntity)this.patreonFlaresClient.computeIfAbsent(owner, o -> new HashMap()).get(pe);
                if (entity == null) {
                    entity = pe.createEntity(owner);
                    if (entity == null) {
                        throw new IllegalStateException("FATAL ERROR: Eventhough a PatreonEffect guaranteed a proper partial entity, it was unable to provide one!");
                    }
                    this.patreonFlaresClient.get(owner).put(pe, entity);
                }
                entity.readFromNBT(flareTag);
            }
        }
        NBTTagList remove = ((DataPatreonFlares)serverData).clientReadBuffer.func_150295_c("flareRemovals", 10);
        for (int i = 0; i < remove.func_74745_c(); ++i) {
            NBTTagCompound cmp = remove.func_150305_b(i);
            UUID owner = cmp.func_186857_a("owner");
            Map<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity> flares = this.patreonFlaresClient.remove(owner);
            if (flares == null) continue;
            for (PatreonPartialEntity flare : flares.values()) {
                flare.setRemoved(true);
            }
        }
    }

    public static class Provider
    extends AbstractData.ProviderAutoAllocate<DataPatreonFlares> {
        public Provider(String key) {
            super(key);
        }

        @Override
        public DataPatreonFlares provideNewInstance(Side side) {
            return new DataPatreonFlares();
        }
    }
}

