/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.tool.ItemSkyResonator;
import hellfirepvp.astralsorcery.common.item.useables.ItemUsableDust;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ResonatorStructureRecipe
extends AttunementRecipe {
    public ResonatorStructureRecipe() {
        super(ShapedRecipe.Builder.newShapedRecipe("internal/altar/resonator/structure", ItemSkyResonator.setCurrentUpgradeUnsafe(ItemSkyResonator.setUpgradeUnlocked(ItemSkyResonator.setEnhanced(new ItemStack((Item)ItemsAS.skyResonator)), ItemSkyResonator.ResonatorUpgrade.AREA_SIZE), ItemSkyResonator.ResonatorUpgrade.AREA_SIZE)).addPart(ItemsAS.skyResonator, ShapedRecipeSlot.CENTER).addPart(ItemUsableDust.DustType.ILLUMINATION.asStack(), ShapedRecipeSlot.UPPER_LEFT, ShapedRecipeSlot.UPPER_RIGHT).addPart(OreDictAlias.ITEM_STARMETAL_DUST, ShapedRecipeSlot.LOWER_LEFT, ShapedRecipeSlot.LOWER_RIGHT).addPart(ItemCraftingComponent.MetaType.GLASS_LENS.asStack(), ShapedRecipeSlot.LEFT, ShapedRecipeSlot.RIGHT).unregisteredAccessibleShapedRecipe());
        this.setAttItem(OreDictAlias.ITEM_STARMETAL_DUST, AttunementRecipe.AttunementAltarSlot.LOWER_LEFT, AttunementRecipe.AttunementAltarSlot.LOWER_RIGHT);
        this.setAttItem(ItemUsableDust.DustType.ILLUMINATION.asStack(), AttunementRecipe.AttunementAltarSlot.UPPER_LEFT, AttunementRecipe.AttunementAltarSlot.UPPER_RIGHT);
        this.setPassiveStarlightRequirement(900);
    }

    @Override
    public boolean matches(TileAltar altar, TileReceiverBaseInventory.ItemHandlerTile invHandler, boolean ignoreStarlightRequirement) {
        ItemStack center = invHandler.getStackInSlot(ShapedRecipeSlot.CENTER.getSlotID());
        if (center.func_190926_b() || !(center.func_77973_b() instanceof ItemSkyResonator)) {
            return false;
        }
        List<ItemSkyResonator.ResonatorUpgrade> out = ItemSkyResonator.getUpgrades(center);
        return !out.contains((Object)ItemSkyResonator.ResonatorUpgrade.AREA_SIZE) && super.matches(altar, invHandler, ignoreStarlightRequirement);
    }

    @Override
    @Nonnull
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar altar) {
        ItemStack reso = new ItemStack((Item)ItemsAS.skyResonator);
        ItemStack center = altar.getInventoryHandler().getStackInSlot(ShapedRecipeSlot.CENTER.getSlotID());
        if (!center.func_190926_b() && center.func_77973_b() instanceof ItemSkyResonator) {
            reso = ItemUtils.copyStackWithSize(center, center.func_190916_E());
        }
        ItemSkyResonator.setEnhanced(reso);
        ItemSkyResonator.setUpgradeUnlocked(reso, ItemSkyResonator.ResonatorUpgrade.AREA_SIZE);
        return reso;
    }
}

