/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.types.IPlayerTickPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;

public class KeyMending
extends KeyPerk
implements IPlayerTickPerk {
    private int chanceToRepair = 800;

    public KeyMending(String name, int x, int y) {
        super(name, x, y);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                KeyMending.this.chanceToRepair = cfg.getInt("Repair_Chance", this.getConfigurationSection(), KeyMending.this.chanceToRepair, 3, 6000000, "Sets the chance (Random.nextInt(chance) == 0) to try to see if a piece of armor on the player that is damageable and damaged can be repaired; the lower the more likely");
            }
        });
    }

    @Override
    protected void applyEffectMultiplier(double multiplier) {
        super.applyEffectMultiplier(multiplier);
        this.chanceToRepair = MathHelper.func_76143_f((double)((double)this.chanceToRepair * multiplier));
    }

    @Override
    public void onPlayerTick(EntityPlayer player, Side side) {
        if (side == Side.SERVER) {
            float fChance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, ResearchManager.getProgress(player, side), "astralsorcery.perkeffect", this.chanceToRepair);
            int chance = Math.max(MathHelper.func_76141_d((float)fChance), 1);
            for (ItemStack armor : player.func_184193_aE()) {
                if (rand.nextInt(chance) != 0 || armor.func_190926_b() || !armor.func_77984_f() || !armor.func_77951_h()) continue;
                armor.func_77964_b(armor.func_77952_i() - 1);
            }
        }
    }
}

