/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect;

import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectAevitas;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectArmara;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectBootes;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectDiscidia;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectEvorsio;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectFornax;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectHorologium;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectLucerna;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectMineralis;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectOctans;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectPelotrio;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectVicio;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.event.APIRegistryEvent;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ConstellationEffectRegistry {
    private static Map<IWeakConstellation, ConstellationEffectProvider> providerMap = new HashMap<IWeakConstellation, ConstellationEffectProvider>();
    private static Map<IWeakConstellation, ConstellationEffect> singleRenderInstances = new HashMap<IWeakConstellation, ConstellationEffect>();

    public static void init() {
        ConstellationEffectRegistry.register(Constellations.aevitas, CEffectAevitas::new);
        ConstellationEffectRegistry.register(Constellations.discidia, CEffectDiscidia::new);
        ConstellationEffectRegistry.register(Constellations.armara, CEffectArmara::new);
        ConstellationEffectRegistry.register(Constellations.vicio, CEffectVicio::new);
        ConstellationEffectRegistry.register(Constellations.evorsio, CEffectEvorsio::new);
        ConstellationEffectRegistry.register(Constellations.mineralis, CEffectMineralis::new);
        ConstellationEffectRegistry.register(Constellations.lucerna, CEffectLucerna::new);
        ConstellationEffectRegistry.register(Constellations.bootes, CEffectBootes::new);
        ConstellationEffectRegistry.register(Constellations.horologium, CEffectHorologium::new);
        ConstellationEffectRegistry.register(Constellations.octans, CEffectOctans::new);
        ConstellationEffectRegistry.register(Constellations.fornax, CEffectFornax::new);
        ConstellationEffectRegistry.register(Constellations.pelotrio, CEffectPelotrio::new);
        MinecraftForge.EVENT_BUS.post((Event)new APIRegistryEvent.ConstellationEffectRegister());
    }

    public static void addDynamicConfigEntries() {
        Config.addDynamicEntry(new CEffectAevitas(null));
        Config.addDynamicEntry(new CEffectDiscidia(null));
        Config.addDynamicEntry(new CEffectArmara(null));
        Config.addDynamicEntry(new CEffectVicio(null));
        Config.addDynamicEntry(new CEffectEvorsio(null));
        Config.addDynamicEntry(new CEffectHorologium(null));
        Config.addDynamicEntry(new CEffectMineralis(null));
        Config.addDynamicEntry(new CEffectLucerna(null));
        Config.addDynamicEntry(new CEffectBootes(null));
        Config.addDynamicEntry(new CEffectOctans(null));
        Config.addDynamicEntry(new CEffectFornax(null));
        Config.addDynamicEntry(new CEffectPelotrio(null));
    }

    private static void register(IWeakConstellation c, ConstellationEffectProvider provider) {
        providerMap.put(c, provider);
        singleRenderInstances.put(c, provider.provideEffectInstance(null));
    }

    public static void registerFromAPI(IWeakConstellation c, Function<ILocatable, ConstellationEffect> providerFunc) {
        providerMap.put(c, new APIConstellationProvider(providerFunc));
        singleRenderInstances.put(c, providerFunc.apply(null));
    }

    @Nullable
    public static ConstellationEffect clientRenderInstance(IWeakConstellation c) {
        return singleRenderInstances.get(c);
    }

    @Nullable
    public static ConstellationEffect getEffect(IWeakConstellation c, ILocatable origin) {
        ConstellationEffectProvider p = providerMap.get(c);
        if (p != null) {
            return p.provideEffectInstance(origin);
        }
        return null;
    }

    public static class APIConstellationProvider
    implements ConstellationEffectProvider {
        private final Function<ILocatable, ConstellationEffect> providerFunc;

        public APIConstellationProvider(Function<ILocatable, ConstellationEffect> providerFunc) {
            this.providerFunc = providerFunc;
        }

        @Override
        public ConstellationEffect provideEffectInstance(ILocatable origin) {
            return this.providerFunc.apply(origin);
        }
    }

    public static interface ConstellationEffectProvider {
        public ConstellationEffect provideEffectInstance(ILocatable var1);
    }
}

