/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.entity;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.models.obj.OBJModelLibrary;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.TextureQuery;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;

public class EffectFloatingCrystal
extends EntityComplexFX {
    private static int dlCrystal = -1;
    private EntityComplexFX.RefreshFunction refreshFunction;
    private EntityComplexFX.PositionController positionUpdateFunction;
    private AbstractRenderableTexture texCrystal = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MODELS, "crystal_big_blue");
    private Color colorTheme = Color.WHITE;
    private double x;
    private double y;
    private double z;
    private double prevX;
    private double prevY;
    private double prevZ;

    public EffectFloatingCrystal setRefreshFunc(EntityComplexFX.RefreshFunction func) {
        this.refreshFunction = func;
        return this;
    }

    public EffectFloatingCrystal setTexture(TextureQuery query) {
        this.texCrystal = query.resolve();
        return this;
    }

    public EffectFloatingCrystal setColorTheme(Color colorTheme) {
        this.colorTheme = colorTheme;
        return this;
    }

    public EffectFloatingCrystal setPositionUpdateFunction(EntityComplexFX.PositionController positionUpdateFunction) {
        this.positionUpdateFunction = positionUpdateFunction;
        return this;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.maxAge >= 0 && this.age >= this.maxAge && this.refreshFunction != null) {
            Entity rView = Minecraft.func_71410_x().func_175606_aa();
            if (rView == null) {
                rView = Minecraft.func_71410_x().field_71439_g;
            }
            if (rView.func_70092_e(this.x, this.y, this.z) <= (double)Config.maxEffectRenderDistanceSq && this.refreshFunction.shouldRefresh()) {
                this.age = 0;
            }
        }
        if (this.positionUpdateFunction != null) {
            this.prevX = this.x;
            this.prevY = this.y;
            this.prevZ = this.z;
            Vector3 newPos = this.positionUpdateFunction.updatePosition(this, new Vector3(this.x, this.y, this.z), new Vector3());
            this.x = newPos.getX();
            this.y = newPos.getY();
            this.z = newPos.getZ();
        }
    }

    @Override
    public void render(float pTicks) {
        Vector3 tr = RenderingUtils.getStandartTranslationRemovalVector(pTicks);
        double iX = RenderingUtils.interpolate(this.prevX, this.x, pTicks);
        double iY = RenderingUtils.interpolate(this.prevY, this.y, pTicks);
        double iZ = RenderingUtils.interpolate(this.prevZ, this.z, pTicks);
        long seed = 5863439008313086302L;
        RenderingUtils.renderLightRayEffects(iX + tr.getX(), iY + 0.2 + tr.getY(), iZ + tr.getZ(), this.colorTheme, seed, ClientScheduler.getClientTick(), 10, 1.4f, 50, 25);
        GlStateManager.func_179094_E();
        RenderingUtils.removeStandartTranslationFromTESRMatrix(pTicks);
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179129_p();
        GlStateManager.func_179098_w();
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)iX, (double)iY, (double)iZ);
        EffectFloatingCrystal.renderTile(this.texCrystal);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179141_d();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private static void renderTile(AbstractRenderableTexture tex) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.05f, (float)0.05f, (float)0.05f);
        tex.bindTexture();
        if (dlCrystal == -1) {
            dlCrystal = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)dlCrystal, (int)4864);
            OBJModelLibrary.bigCrystal.renderAll(true);
            GlStateManager.func_187415_K();
        }
        GlStateManager.func_179148_o((int)dlCrystal);
        GlStateManager.func_179121_F();
    }
}

