/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.data;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.data.CachedPersistentData;
import hellfirepvp.astralsorcery.client.data.KnowledgeFragmentData;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PersistentDataManager {
    public static final PersistentDataManager INSTANCE = new PersistentDataManager();
    private static final String[] infoFileContents = new String[]{"Astral Sorcery's persistent data directory", "Astral Sorcery stores various informations here to ensure they are persistent across several playthroughs", "of different modpacks. Thus, no matter what pack you play, these files end up here.", "", "Files saved here are saved in an NBT format and can't be opened directly on many systems.", "See 'NBTExplorer' or related software to open and modify the files if needed.", "", "Should you wish to disable some or all features accessing the permanent storage, check", "Astral Sorcery's configuration file and disable all or individual features."};
    private File selectedPersistentDataFolder;
    private File localModPackFolder;
    private boolean useLocal = false;
    private boolean initialized = false;
    private boolean active = true;
    private Map<PersistentKey, Boolean> activeMap = Maps.newHashMap();
    private Map<PersistentKey, CachedPersistentData> cachedPersistentData = Maps.newHashMap();
    private static final String dirWindows = "\\AppData\\Roaming\\.minecraft\\astralsorcery_persistent";
    private static final String dirMac = "/Library/Application Support/minecraft/astralsorcery_persistent";
    private static final String dirOther = "/.minecraft/astralsorcery_persistent";

    private PersistentDataManager() {
    }

    public boolean usePersistent() {
        return !this.useLocal;
    }

    public void init(File localDataDirectory) {
        File dataDir;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.active) {
            dataDir = this.resolvePersistentDataFolder();
            if (dataDir == null) {
                dataDir = localDataDirectory;
                this.useLocal = true;
            } else {
                this.useLocal = false;
            }
        } else {
            dataDir = localDataDirectory;
            this.useLocal = true;
        }
        if (!dataDir.exists() && !dataDir.mkdirs()) {
            AstralSorcery.log.info("Unable to create folder for persistent data. Are you sure the mod has the permissions to create files there?");
            return;
        }
        if (!(dataDir.equals(localDataDirectory) || localDataDirectory.exists() || localDataDirectory.mkdirs())) {
            AstralSorcery.log.info("Unable to create folder for persistent data. Are you sure the mod has the permissions to create files there?");
            return;
        }
        this.selectedPersistentDataFolder = dataDir;
        this.localModPackFolder = localDataDirectory;
        this.checkInfoFile();
        for (PersistentKey key : PersistentKey.values()) {
            if (!this.loadPersistentData(key)) continue;
            this.savePersistentData((CachedPersistentData)this.getData(key));
        }
    }

    @Nonnull
    public <T extends CachedPersistentData> T getData(PersistentKey key) {
        return (T)this.cachedPersistentData.getOrDefault((Object)key, key.provideEmptyInstance());
    }

    private File resolvePersistentDataFolder() {
        String userHome = System.getProperty("user.home");
        String userOS = System.getProperty("os.name");
        if (userOS == null) {
            AstralSorcery.log.info("Unable to determine User OS. Unable to select appropriate directory. Using local/pack-dependent directory!");
            return null;
        }
        String dir = (userOS = userOS.toLowerCase()).startsWith("windows") ? dirWindows : (userOS.startsWith("mac") ? dirMac : dirOther);
        String folderPath = userHome + dir;
        return new File(folderPath);
    }

    boolean savePersistentData(CachedPersistentData data) {
        PersistentKey key = data.getKey();
        File dataFile = this.getKeyFile(key);
        if (dataFile == null) {
            return false;
        }
        NBTTagCompound tag = new NBTTagCompound();
        data.writeToNBT(tag);
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)tag, (File)dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean loadPersistentData(PersistentKey key) {
        CachedPersistentData data;
        File dataFile = this.getKeyFile(key);
        if (dataFile == null) {
            return false;
        }
        try {
            NBTTagCompound tag = CompressedStreamTools.func_74797_a((File)dataFile);
            data = key.provideEmptyInstance();
            data.readFromNBT(tag);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        boolean mergedData = false;
        if (!this.useLocal || !this.activeMap.getOrDefault((Object)key, false).booleanValue()) {
            try {
                File localFile = this.getLocalModPackKeyFile(key);
                if (localFile.exists()) {
                    NBTTagCompound prevTag = CompressedStreamTools.func_74797_a((File)localFile);
                    CachedPersistentData prevData = key.provideEmptyInstance();
                    prevData.readFromNBT(prevTag);
                    mergedData = data.mergeFrom(prevData);
                }
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
        this.cachedPersistentData.put(key, data);
        return mergedData;
    }

    private File getKeyFile(PersistentKey key) {
        return this.resolveFile(key.getFileName(), this.activeMap.getOrDefault((Object)key, false) != false ? this.selectedPersistentDataFolder : this.localModPackFolder, true);
    }

    private File getLocalModPackKeyFile(PersistentKey key) {
        return this.resolveFile(key.getFileName(), this.localModPackFolder, false);
    }

    private File resolveFile(String name, File folder, boolean createFile) {
        File dataFile = new File(folder, name);
        if (createFile && !dataFile.exists()) {
            try {
                CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)dataFile);
            }
            catch (IOException exc) {
                exc.printStackTrace();
                return null;
            }
        }
        return dataFile;
    }

    private void checkInfoFile() {
        if (this.useLocal) {
            return;
        }
        File infoFile = new File(this.selectedPersistentDataFolder, "info.txt");
        if (!infoFile.exists()) {
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(infoFile));){
                for (String line : infoFileContents) {
                    bw.write(line);
                    bw.newLine();
                }
                bw.flush();
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
    }

    public void setCreative() {
        for (CachedPersistentData data : this.cachedPersistentData.values()) {
            data.setCreativeFlag();
        }
    }

    public void clearCreative() {
        for (CachedPersistentData data : this.cachedPersistentData.values()) {
            data.clearCreativeFlag();
        }
    }

    public static enum PersistentKey {
        KNOWLEDGE_FRAGMENTS("knowledge_fragments.dat", v -> new KnowledgeFragmentData());

        private final String fileName;
        private final Function<Void, CachedPersistentData> dataProvider;

        private PersistentKey(String fileName, Function<Void, CachedPersistentData> dataProvider) {
            this.fileName = fileName;
            this.dataProvider = dataProvider;
        }

        public CachedPersistentData provideEmptyInstance() {
            return this.dataProvider.apply(null);
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    public static class ConfigPersistency
    extends ConfigEntry {
        public ConfigPersistency() {
            super(ConfigEntry.Section.DATA_PERSISTENCE, "files");
        }

        @Override
        public final void loadFromConfig(Configuration cfg) {
            PersistentDataManager mgr = INSTANCE;
            mgr.active = cfg.getBoolean("active", this.getConfigurationSection(), true, "Defines if the persistent client-data usage/storage should be used. If set to false, it'll store the data in a pack-related directory (subfolder 'astralsorcery' in the same directory as /mods, /config, ...)");
            for (PersistentKey key : PersistentKey.values()) {
                mgr.activeMap.put(key, cfg.getBoolean("active_" + key.getName(), this.getConfigurationSection(), true, "Defines if the persistent data loading & saving should be enabled for " + key.getName() + " (saved in file " + key.getFileName() + ")"));
            }
        }
    }
}

