/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import appeng.api.AEApi;
import appeng.api.storage.ICellRegistry;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import extracells.util.StorageChannels;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class AEUtils {
    public static IAEItemStack createItemStack(ItemStack itemStack) {
        return (IAEItemStack)StorageChannels.ITEM().createStack((Object)itemStack);
    }

    public static IAEFluidStack createFluidStack(Fluid fluid) {
        return AEUtils.createFluidStack(new FluidStack(fluid, 1000));
    }

    public static IAEFluidStack createFluidStack(Fluid fluid, long amount) {
        return fluid == null ? null : (IAEFluidStack)AEUtils.createFluidStack(new FluidStack(fluid, 1)).setStackSize(amount);
    }

    public static IAEFluidStack createFluidStack(String fluidName, long amount) {
        return AEUtils.createFluidStack(FluidRegistry.getFluid((String)fluidName), amount);
    }

    public static IAEFluidStack createFluidStack(FluidStack fluid) {
        return fluid == null ? null : (IAEFluidStack)StorageChannels.FLUID().createStack((Object)fluid);
    }

    public static boolean isItemChannel(IStorageChannel channel) {
        return channel == AEUtils.getItemChannel();
    }

    public static boolean isFluidChannel(IStorageChannel channel) {
        return channel == AEUtils.getFluidChannel();
    }

    public static IStorageChannel getItemChannel() {
        return StorageChannels.ITEM();
    }

    public static IStorageChannel getFluidChannel() {
        return StorageChannels.FLUID();
    }

    public static ICellRegistry cell() {
        return AEApi.instance().registries().cell();
    }
}

