/*
 * Decompiled with CFR 0.152.
 */
package extracells.part.fluid;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import extracells.models.PartModels;
import extracells.part.fluid.PartFluidStorageMonitor;
import extracells.util.AEUtils;
import extracells.util.FluidHelper;
import extracells.util.MachineSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class PartFluidConversionMonitor
extends PartFluidStorageMonitor {
    protected boolean wasActivated(EntityPlayer player, EnumHand hand, Vec3d pos) {
        return super.onActivate(player, hand, pos);
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        boolean wasActivated = super.onActivate(player, hand, pos);
        if (wasActivated) {
            return wasActivated;
        }
        if (player == null || player.field_70170_p == null) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        IMEMonitor<IAEFluidStack> mon = this.getFluidStorage();
        if (this.locked && heldItem != null && !heldItem.func_190926_b() && mon != null) {
            ItemStack itemStack = heldItem.func_77946_l();
            itemStack.func_190920_e(1);
            if (FluidHelper.isDrainableFilledContainer(itemStack)) {
                FluidStack f = FluidHelper.getFluidFromContainer(itemStack);
                if (f == null) {
                    return true;
                }
                IAEFluidStack fluidStack = AEUtils.createFluidStack(f);
                IAEFluidStack injectItems = (IAEFluidStack)mon.injectItems((IAEStack)fluidStack.copy(), Actionable.SIMULATE, (IActionSource)new MachineSource(this));
                if (mon.canAccept((IAEStack)fluidStack) && (injectItems == null || injectItems.getStackSize() == 0L)) {
                    mon.injectItems((IAEStack)fluidStack, Actionable.MODULATE, (IActionSource)new MachineSource(this));
                    Pair<Integer, ItemStack> emptyStack = FluidHelper.drainStack(itemStack, f);
                    ItemStack empty = (ItemStack)emptyStack.getRight();
                    if (empty != null && !empty.func_190926_b()) {
                        this.dropItems(this.getHost().getTile().func_145831_w(), this.getHost().getTile().func_174877_v().func_177972_a(this.getFacing()), empty);
                    }
                    ItemStack s3 = heldItem.func_77946_l();
                    s3.func_190920_e(s3.func_190916_E() - 1);
                    if (s3.func_190916_E() == 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    } else {
                        player.func_184611_a(hand, s3);
                    }
                }
                return true;
            }
            if (FluidHelper.isFillableContainerWithRoom(itemStack)) {
                if (this.fluid == null) {
                    return true;
                }
                IAEFluidStack extract = (IAEFluidStack)mon.extractItems((IAEStack)AEUtils.createFluidStack(this.fluid), Actionable.SIMULATE, (IActionSource)new MachineSource(this));
                if (extract != null) {
                    mon.extractItems((IAEStack)AEUtils.createFluidStack(new FluidStack(this.fluid, (int)extract.getStackSize())), Actionable.MODULATE, (IActionSource)new MachineSource(this));
                    Pair<Integer, ItemStack> empty1 = FluidHelper.fillStack(itemStack, extract.getFluidStack());
                    if ((Integer)empty1.getKey() == 0) {
                        mon.injectItems((IAEStack)AEUtils.createFluidStack(new FluidStack(this.fluid, (int)extract.getStackSize())), Actionable.MODULATE, (IActionSource)new MachineSource(this));
                        return true;
                    }
                    ItemStack empty = (ItemStack)empty1.getRight();
                    if (empty != null && !empty.func_190926_b()) {
                        this.dropItems(this.getHost().getTile().func_145831_w(), this.getHost().getTile().func_174877_v().func_177972_a(this.getFacing()), empty);
                    }
                    ItemStack s3 = heldItem.func_77946_l();
                    s3.func_190920_e(s3.func_190916_E() - 1);
                    if (s3.func_190916_E() == 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    } else {
                        player.func_184611_a(hand, s3);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return PartModels.CONVERSION_MONITOR_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.CONVERSION_MONITOR_ON;
        }
        return PartModels.CONVERSION_MONITOR_OFF;
    }
}

