/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui.widget.fluid;

import appeng.api.storage.data.IAEFluidStack;
import extracells.gui.widget.fluid.AbstractFluidWidget;
import extracells.gui.widget.fluid.IFluidSelectorGui;
import extracells.integration.Integration;
import extracells.util.ECConfigHandler;
import extracells.util.GasUtil;
import java.util.ArrayList;
import mekanism.api.gas.Gas;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class WidgetFluidSelector
extends AbstractFluidWidget {
    private long amount = 0L;
    private int color;
    private int borderThickness;

    public WidgetFluidSelector(IFluidSelectorGui guiFluidTerminal, IAEFluidStack stack) {
        super(guiFluidTerminal, 18, 18, stack.getFluidStack().getFluid());
        this.amount = stack.getStackSize();
        this.color = -16711681;
        this.borderThickness = 1;
    }

    private void drawHollowRectWithCorners(int posX, int posY, int height, int width, int color, int thickness) {
        WidgetFluidSelector.func_73734_a((int)posX, (int)posY, (int)(posX + height), (int)(posY + thickness), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)(posY + width - thickness), (int)(posX + height), (int)(posY + width), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)posY, (int)(posX + thickness), (int)(posY + width), (int)color);
        WidgetFluidSelector.func_73734_a((int)(posX + height - thickness), (int)posY, (int)(posX + height), (int)(posY + width), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)posY, (int)(posX + thickness + 1), (int)(posY + thickness + 1), (int)color);
        WidgetFluidSelector.func_73734_a((int)(posX + height), (int)(posY + width), (int)(posX + height - thickness - 1), (int)(posY + width - thickness - 1), (int)color);
        WidgetFluidSelector.func_73734_a((int)(posX + height), (int)posY, (int)(posX + height - thickness - 1), (int)(posY + thickness + 1), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)(posY + width), (int)(posX + thickness + 1), (int)(posY + width - thickness - 1), (int)color);
    }

    @Override
    public boolean drawTooltip(int posX, int posY, int mouseX, int mouseY) {
        if (this.fluid == null || this.amount <= 0L || !this.isPointInRegion(posX, posY, this.height, this.width, mouseX, mouseY)) {
            return false;
        }
        String amountToText = Long.toString(this.amount) + "mB";
        if (ECConfigHandler.shortenedBuckets) {
            if (this.amount > 1000000000L) {
                amountToText = Long.toString(this.amount / 1000000000L) + "MegaB";
            } else if (this.amount > 1000000L) {
                amountToText = Long.toString(this.amount / 1000000L) + "KiloB";
            } else if (this.amount > 9999L) {
                amountToText = Long.toString(this.amount / 1000L) + "B";
            }
        }
        ArrayList<String> description = new ArrayList<String>();
        description.add(this.fluid.getLocalizedName(new FluidStack(this.fluid, 0)));
        description.add(amountToText);
        this.drawHoveringText(description, mouseX - this.guiFluidTerminal.guiLeft(), mouseY - this.guiFluidTerminal.guiTop() + 18, Minecraft.func_71410_x().field_71466_p);
        return true;
    }

    @Override
    public void drawWidget(int posX, int posY) {
        Fluid currentFluid;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        IAEFluidStack terminalFluid = ((IFluidSelectorGui)this.guiFluidTerminal).getCurrentFluid();
        Fluid fluid = currentFluid = terminalFluid != null ? terminalFluid.getFluid() : null;
        if (this.fluid != null) {
            TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
            if (Integration.Mods.MEKANISMGAS.isEnabled() && GasUtil.isGas(this.fluid)) {
                Gas gas = GasUtil.getGas(this.fluid);
                ResourceLocation gasStill = gas.getIcon();
                TextureAtlasSprite gasStillSprite = null;
                if (gasStill != null) {
                    gasStillSprite = textureMap.getTextureExtry(gasStill.toString());
                }
                if (gasStillSprite == null) {
                    gasStillSprite = textureMap.func_110572_b(this.fluid.getStill().toString());
                }
                int tint = gas.getTint();
                float r = (float)(tint >> 16 & 0xFF) / 255.0f;
                float g = (float)(tint >> 8 & 0xFF) / 255.0f;
                float b = (float)(tint & 0xFF) / 255.0f;
                GlStateManager.func_179124_c((float)r, (float)g, (float)b);
                this.func_175175_a(posX + 1, posY + 1, gasStillSprite, this.height - 2, this.width - 2);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                TextureAtlasSprite sprite = textureMap.func_110572_b(this.fluid.getStill().toString());
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                this.func_175175_a(posX + 1, posY + 1, sprite, this.height - 2, this.width - 2);
            }
        }
        if (this.fluid == currentFluid) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.drawHollowRectWithCorners(posX, posY, this.height, this.width, this.color, this.borderThickness);
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public long getAmount() {
        return this.amount;
    }

    @Override
    public void mouseClicked(int posX, int posY, int mouseX, int mouseY) {
        if (this.fluid != null && this.isPointInRegion(posX, posY, this.height, this.width, mouseX, mouseY)) {
            ((IFluidSelectorGui)this.guiFluidTerminal).getContainer().setSelectedFluid(this.fluid);
        }
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }
}

