/*
 * Decompiled with CFR 0.152.
 */
package extracells.definitions;

import appeng.api.definitions.ITileDefinition;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockItemDefinitions
implements ITileDefinition {
    private final Block block;
    private final int meta;
    private final Class<? extends TileEntity> blockTileEntity;

    public BlockItemDefinitions(Block block) {
        this(block, 0);
    }

    public BlockItemDefinitions(Block block, Class<? extends TileEntity> blockTileEntity) {
        this(block, 0, blockTileEntity);
    }

    public BlockItemDefinitions(Block block, int meta) {
        this(block, meta, null);
    }

    public BlockItemDefinitions(Block block, int meta, Class<? extends TileEntity> blockTileEntity) {
        this.block = block;
        this.meta = meta;
        this.blockTileEntity = blockTileEntity;
    }

    public Optional<Block> maybeBlock() {
        return Optional.ofNullable(this.block);
    }

    public Optional<ItemBlock> maybeItemBlock() {
        return Optional.empty();
    }

    public boolean isSameAs(ItemStack comparableStack) {
        return comparableStack != null && ItemStack.func_77989_b((ItemStack)this.maybeStack(1).get(), (ItemStack)comparableStack);
    }

    public boolean isSameAs(IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return !this.maybeBlock().isPresent() && block == this.block;
    }

    public Optional<Item> maybeItem() {
        return Optional.ofNullable(Item.func_150898_a((Block)this.block));
    }

    public Optional<ItemStack> maybeStack(int stackSize) {
        return Optional.of(new ItemStack(this.block, stackSize, this.meta));
    }

    public boolean isEnabled() {
        return true;
    }

    public Optional<? extends Class<? extends TileEntity>> maybeEntity() {
        return Optional.ofNullable(this.blockTileEntity);
    }

    @Nonnull
    public String identifier() {
        return this.block.getRegistryName().func_110623_a();
    }
}

