/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.tools.nbt;

import java.util.Arrays;
import landmaster.plustic.tools.nbt.ToolEnergyNBT;
import landmaster.plustic.tools.stats.LaserMediumMaterialStats;
import net.minecraft.nbt.NBTTagCompound;

public class LaserNBT
extends ToolEnergyNBT {
    public static final String TagPOWER = "LaserGunPower";
    public static final String TagRANGE = "LaserGunRange";
    public float power;
    public float range;

    public LaserNBT() {
        this.power = 0.0f;
    }

    public LaserNBT(NBTTagCompound nbt) {
        super(nbt);
    }

    public LaserNBT laserMedium(LaserMediumMaterialStats ... stats) {
        this.power = (float)Arrays.stream(stats).filter(stat -> stat != null).mapToDouble(stat -> stat.power).sum() / (float)stats.length;
        this.range = (float)Arrays.stream(stats).filter(stat -> stat != null).mapToDouble(stat -> stat.range).sum() / (float)stats.length;
        this.attack = this.power;
        return this;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        this.power = tag.func_74760_g(TagPOWER);
        this.range = tag.func_74760_g(TagRANGE);
    }

    @Override
    public void write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74776_a(TagPOWER, this.power);
        tag.func_74776_a(TagRANGE, this.range);
    }
}

