/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.block;

import java.util.List;
import javax.annotation.Nullable;
import landmaster.plustic.PlusTiC;
import landmaster.plustic.block.IMetaBlockName;
import landmaster.plustic.tile.TECentrifugeCore;
import landmaster.plustic.tile.TECentrifugeTank;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;

public class BlockCentrifuge
extends Block
implements IMetaBlockName {
    public static final PropertyBool CORE = PropertyBool.func_177716_a((String)"core");

    public BlockCentrifuge() {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(10.0f);
        this.func_149752_b(80.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CORE, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("centrifuge").setRegistryName("centrifuge");
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabSmeltery);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CORE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CORE, (Comparable)Boolean.valueOf(meta != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CORE) != false ? 1 : 0;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this));
        list.add((Object)new ItemStack((Block)this, 1, 1));
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77960_j() != 0 ? "core" : "tank";
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CORE) != false ? new TECentrifugeCore() : new TECentrifugeTank();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            return false;
        }
        IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)fluidHandler)) {
            return true;
        }
        if (((Boolean)state.func_177229_b((IProperty)CORE)).booleanValue() && !(Block.func_149634_a((Item)heldItem.func_77973_b()) instanceof BlockCentrifuge)) {
            if (!worldIn.field_72995_K) {
                playerIn.openGui((Object)PlusTiC.INSTANCE, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return FluidUtil.getFluidHandler((ItemStack)heldItem) != null;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        for (ItemStack drop : drops) {
            if (!(Block.func_149634_a((Item)drop.func_77973_b()) instanceof BlockCentrifuge)) continue;
            drop.func_77982_d(new NBTTagCompound());
            drop.func_77978_p().func_74782_a("BlockEntityTag", (NBTBase)world.func_175625_s(pos).serializeNBT());
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        NBTTagCompound blockEntityTag = stack.func_179543_a("BlockEntityTag");
        if (blockEntityTag != null && blockEntityTag.func_150297_b("Tank", 10)) {
            FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)blockEntityTag.func_74775_l("Tank"));
            tooltip.add(I18n.func_135052_a((String)"tooltip.plustic.centrifuge.fluid_info", (Object[])new Object[]{fs.getLocalizedName(), fs.amount}));
        }
    }
}

