/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.compatibility.CompatHelper112;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.machine.EnergyBaseRecipe;
import com.rwtema.extrautils2.utils.LogHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.AbstractBrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import org.apache.commons.lang3.tuple.Pair;

class BrewingEnergyRecipe
extends EnergyBaseRecipe {
    private HashMap<PotionType, Integer> types = new HashMap();
    private HashMap<Item, Integer> potions = new HashMap();
    private int prevSize = -1;

    BrewingEnergyRecipe() {
    }

    public void checkTypes() {
        int curSize = PotionType.field_185176_a.func_148742_b().size() + Potion.field_188414_b.func_148742_b().size() + BrewingRecipeRegistry.getRecipes().size();
        if (curSize != this.prevSize) {
            boolean flag;
            this.prevSize = curSize;
            this.types.clear();
            this.potions.clear();
            for (Object predicate : PotionHelper.field_185214_b) {
                this.potions.put((Item)CompatHelper112.getPotionInput(predicate), 0);
            }
            for (Object predicate : PotionHelper.field_185214_b) {
                this.potions.remove(CompatHelper112.getPotionOutput(predicate));
            }
            this.potions.put((Item)Items.field_151068_bn, 0);
            do {
                flag = false;
                for (PotionHelper.MixPredicate predicate : PotionHelper.field_185214_b) {
                    if (!this.potions.containsKey(CompatHelper112.getPotionInput(predicate)) || this.potions.containsKey(CompatHelper112.getPotionOutput(predicate))) continue;
                    this.potions.put((Item)CompatHelper112.getPotionOutput(predicate), this.potions.get(CompatHelper112.getPotionInput(predicate)) + 1);
                    flag = true;
                }
            } while (flag);
            List<Object> links = new ArrayList();
            links.addAll(PotionHelper.field_185213_a.stream().map(CompatHelper112::createLink).collect(Collectors.toList()));
            links.addAll(BrewingRecipeRegistry.getRecipes().stream().filter(t -> t instanceof AbstractBrewingRecipe).map(t -> this.createLink((AbstractBrewingRecipe)t)).collect(Collectors.toList()));
            links = links.stream().filter(t -> t.getLeft() != null && t.getRight() != null && t.getLeft() != t.getRight()).collect(Collectors.toList());
            LinkedHashSet set = new LinkedHashSet();
            Iterables.addAll(set, (Iterable)PotionType.field_185176_a);
            set.addAll(links.stream().map(Pair::getLeft).collect(Collectors.toList()));
            set.addAll(links.stream().map(Pair::getRight).collect(Collectors.toList()));
            this.types.put(PotionTypes.field_185230_b, 0);
            do {
                flag = false;
                for (Pair pair : links) {
                    if (!this.types.containsKey(pair.getLeft()) || this.types.containsKey(pair.getRight())) continue;
                    this.types.put((PotionType)pair.getRight(), this.types.get(pair.getLeft()) + 1);
                    flag = true;
                }
            } while (flag);
            for (PotionType potionType : set) {
                LogHelper.info(PotionType.field_185176_a.func_177774_c((Object)potionType) + " " + this.types.get(potionType), new Object[0]);
            }
        }
    }

    public Pair<PotionType, PotionType> createLink(AbstractBrewingRecipe recipe) {
        return Pair.of((Object)this.getPotionFromItem(recipe.getInput()), (Object)this.getPotionFromItem(recipe.getOutput()));
    }

    @Nullable
    private PotionType getPotionFromItem(ItemStack input) {
        NBTTagCompound tag = input.func_77978_p();
        if (tag == null) {
            if (input.func_77973_b() == Items.field_151068_bn) {
                return PotionTypes.field_185230_b;
            }
            return null;
        }
        ResourceLocation potion = new ResourceLocation(tag.func_74779_i("Potion"));
        if (!PotionType.field_185176_a.func_148741_d((Object)potion)) {
            return null;
        }
        return (PotionType)PotionType.field_185176_a.func_82594_a((Object)potion);
    }

    @Override
    public int getEnergyOutput(@Nonnull ItemStack stack) {
        this.checkTypes();
        Integer j = this.potions.get(stack.func_77973_b());
        if (j == null) {
            return 0;
        }
        PotionType type = this.getPotionFromItem(stack);
        if (type == null) {
            return 0;
        }
        Integer i = this.types.get(type);
        if (i == null) {
            return 0;
        }
        return (int)(100.0 * Math.pow(4.0, Math.min(6, i + j)));
    }

    @Override
    protected float getEnergyRate(@Nonnull ItemStack stack) {
        this.checkTypes();
        Integer j = this.potions.get(stack.func_77973_b());
        if (j == null) {
            return 0.0f;
        }
        PotionType type = this.getPotionFromItem(stack);
        if (type == null) {
            return 0.0f;
        }
        Integer i = this.types.get(type);
        if (i == null) {
            return 0.0f;
        }
        return (int)(Math.pow(2.0, i + j) * 10.0);
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getInputValues() {
        this.checkTypes();
        return Stream.concat(Stream.concat(ExtraUtils2.proxy.getSubItems((Item)Items.field_151068_bn).stream(), ExtraUtils2.proxy.getSubItems((Item)Items.field_185156_bI).stream()), ExtraUtils2.proxy.getSubItems((Item)Items.field_185155_bH).stream()).filter(t -> this.getEnergyOutput((ItemStack)t) > 0).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public ItemStack getContainer(ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return StackHelper.empty();
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151068_bn || item == Items.field_185155_bH || item == Items.field_185156_bI) {
            return new ItemStack(Items.field_151069_bo);
        }
        return super.getContainer(stack);
    }
}

