/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.rwtema.extrautils2.api.resonator.IResonatorRecipe;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.crafting.jei.XUJEIPlugin;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;

public class JEIResonatorHandler
extends BlankRecipeCategory<ResonatorWrapper>
implements IRecipeHandler<IResonatorRecipe>,
IRecipeCategory<ResonatorWrapper> {
    public static final String uid = "extrautils2.resonator";
    public static final int recipeWidth = 116;
    public static final int BETWEEN_DIST = 60;
    public static final int slotX1 = 79;
    public static final int slotX0 = 19;
    public static final int arrowX = 47;
    IDrawable slotDrawable = XUJEIPlugin.jeiHelpers.getGuiHelper().getSlotDrawable();
    IDrawable background = XUJEIPlugin.jeiHelpers.getGuiHelper().createBlankDrawable(116, 54);
    IDrawable arrowBack = XUJEIPlugin.jeiHelpers.getGuiHelper().createDrawable(DynamicGui.texWidgets, 98, 0, 22, 16);

    @Nonnull
    public Class<IResonatorRecipe> getRecipeClass() {
        return IResonatorRecipe.class;
    }

    @Nonnull
    public String getRecipeCategoryUid() {
        return uid;
    }

    @Nonnull
    public String getRecipeCategoryUid(@Nonnull IResonatorRecipe recipe) {
        return uid;
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull IResonatorRecipe recipe) {
        return new ResonatorWrapper(recipe);
    }

    public boolean isRecipeValid(@Nonnull IResonatorRecipe recipe) {
        return !recipe.getInputs().isEmpty();
    }

    @Nonnull
    public String getUid() {
        return uid;
    }

    @Nonnull
    public String getTitle() {
        return Lang.getItemName((Block)XU2Entries.resonator.value);
    }

    public String getModName() {
        return "extrautils2";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.slotDrawable.draw(minecraft, 19, 14);
        this.slotDrawable.draw(minecraft, 79, 14);
        this.arrowBack.draw(minecraft, 47, 14);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull ResonatorWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 19, 14);
        guiItemStacks.set(0, recipeWrapper.IResonatorRecipe.getInputs());
        guiItemStacks.init(1, false, 79, 14);
        guiItemStacks.set(1, recipeWrapper.IResonatorRecipe.getOutput());
    }

    public static class ResonatorWrapper
    extends BlankRecipeWrapper {
        private final IResonatorRecipe IResonatorRecipe;
        String energyString;
        String txtString;

        public ResonatorWrapper(IResonatorRecipe IResonatorRecipe2) {
            this.IResonatorRecipe = IResonatorRecipe2;
            this.energyString = Lang.translateArgs("%s GP", StringHelper.niceFormat((double)IResonatorRecipe2.getEnergy() / 100.0));
            this.txtString = IResonatorRecipe2.getRequirementText();
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInputs(ItemStack.class, this.IResonatorRecipe.getInputs());
            ingredients.setOutput(ItemStack.class, (Object)this.IResonatorRecipe.getOutput());
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int stringWidth = minecraft.field_71466_p.func_78256_a(this.energyString);
            minecraft.field_71466_p.func_78279_b(this.energyString, Math.max(19, (recipeWidth - stringWidth) / 2), 4, 60, Color.gray.getRGB());
            stringWidth = minecraft.field_71466_p.func_78256_a(this.txtString);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)recipeWidth / 2.0f), (float)34.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)1.0);
            minecraft.field_71466_p.func_78276_b(this.txtString, -stringWidth / 2, 0, Color.gray.getRGB());
            GlStateManager.func_179121_F();
        }

        public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }
}

