/*
 * Decompiled with CFR 0.152.
 */
package link.infra.demagnetize.network;

import io.netty.buffer.ByteBuf;
import link.infra.demagnetize.Demagnetize;
import link.infra.demagnetize.blocks.DemagnetizerTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDemagnetizerSettings
implements IMessage {
    private int range;
    private DemagnetizerTileEntity.RedstoneStatus redstoneSetting = DemagnetizerTileEntity.RedstoneStatus.REDSTONE_DISABLED;
    private boolean whitelist;
    private BlockPos demagnetizerBlockPos;

    public void fromBytes(ByteBuf buf) {
        this.range = buf.readInt();
        try {
            this.redstoneSetting = DemagnetizerTileEntity.RedstoneStatus.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.whitelist = buf.readBoolean();
        this.demagnetizerBlockPos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.range);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.redstoneSetting.name());
        buf.writeBoolean(this.whitelist);
        buf.writeLong(this.demagnetizerBlockPos.func_177986_g());
    }

    public PacketDemagnetizerSettings() {
    }

    public PacketDemagnetizerSettings(int range, DemagnetizerTileEntity.RedstoneStatus redstoneSetting, boolean whitelist, BlockPos demagnetizerBlockPos) {
        this.range = range;
        this.redstoneSetting = redstoneSetting;
        this.whitelist = whitelist;
        this.demagnetizerBlockPos = demagnetizerBlockPos;
    }

    public static class Handler
    implements IMessageHandler<PacketDemagnetizerSettings, IMessage> {
        public IMessage onMessage(PacketDemagnetizerSettings message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketDemagnetizerSettings message, MessageContext ctx) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            World world = playerEntity.func_130014_f_();
            if (world.func_175667_e(message.demagnetizerBlockPos)) {
                TileEntity te = world.func_175625_s(message.demagnetizerBlockPos);
                if (te instanceof DemagnetizerTileEntity) {
                    DemagnetizerTileEntity demagTE = (DemagnetizerTileEntity)te;
                    demagTE.setRange(message.range);
                    demagTE.setRedstoneSetting(message.redstoneSetting);
                    demagTE.setWhitelist(message.whitelist);
                    demagTE.updateBlock();
                } else {
                    Demagnetize.logger.warn("Player tried to change settings of something that isn't a demagnetizer (or doesn't have a TE)!");
                }
            }
        }
    }
}

