/*
 * Decompiled with CFR 0.152.
 */
package link.infra.demagnetize.blocks;

import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;
import link.infra.demagnetize.ConfigHandler;
import link.infra.demagnetize.blocks.DemagnetizerEventHandler;
import link.infra.demagnetize.network.PacketDemagnetizerSettings;
import link.infra.demagnetize.network.PacketHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;

public class DemagnetizerTileEntity
extends TileEntity
implements ITickable {
    private AxisAlignedBB scanArea;
    private int range;
    private RedstoneStatus redstoneSetting = RedstoneStatus.REDSTONE_DISABLED;
    private boolean filtersWhitelist = false;
    private boolean isPowered = false;
    private Deque<WeakReference<EntityItem>> itemUpdateQueue = new ArrayDeque<WeakReference<EntityItem>>();
    private final int tickTime = 4;
    private int currTick = 4;
    ItemStackHandler itemStackHandler = new ItemStackHandler(this.getFilterSize()){

        protected void onContentsChanged(int slot) {
            DemagnetizerTileEntity.this.func_70296_d();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            this.stacks.set(slot, (Object)ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        }
    };

    DemagnetizerTileEntity() {
        this.range = this.getMaxRange();
        this.updateBoundingBox();
        DemagnetizerEventHandler.addTileEntity(this);
    }

    public int getMaxRange() {
        return ConfigHandler.demagnetizerRange;
    }

    private void updateBoundingBox() {
        int negRange = this.range * -1;
        this.scanArea = new AxisAlignedBB(this.func_174877_v().func_177982_a(negRange, negRange, negRange), this.func_174877_v().func_177982_a(this.range, this.range, this.range));
    }

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        this.updateBoundingBox();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readInternalNBT(compound);
    }

    void readInternalNBT(NBTTagCompound compound) {
        int pendingRange;
        if (compound.func_74764_b("items")) {
            NBTTagCompound itemsTag = (NBTTagCompound)compound.func_74781_a("items");
            itemsTag.func_74768_a("Size", this.getFilterSize());
            this.itemStackHandler.deserializeNBT(itemsTag);
        }
        if (compound.func_74764_b("redstone")) {
            try {
                this.redstoneSetting = RedstoneStatus.valueOf(compound.func_74779_i("redstone"));
            }
            catch (IllegalArgumentException itemsTag) {
                // empty catch block
            }
        }
        if (compound.func_74764_b("range") && (pendingRange = compound.func_74762_e("range")) <= this.getMaxRange() && pendingRange > 0) {
            this.range = pendingRange;
            this.updateBoundingBox();
        }
        if (compound.func_74764_b("whitelist")) {
            this.filtersWhitelist = compound.func_74767_n("whitelist");
        }
        if (compound.func_74764_b("redstonePowered")) {
            this.isPowered = compound.func_74767_n("redstonePowered");
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeInternalNBT(compound);
        return compound;
    }

    void writeInternalNBT(NBTTagCompound compound) {
        compound.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74778_a("redstone", this.redstoneSetting.name());
        compound.func_74768_a("range", this.range);
        compound.func_74757_a("whitelist", this.filtersWhitelist);
        compound.func_74757_a("redstonePowered", this.isPowered);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_73660_a() {
        if (this.func_145837_r()) {
            DemagnetizerEventHandler.removeTileEntity(this);
            return;
        }
        if (this.redstoneUnpowered()) {
            this.currTick = 4;
            return;
        }
        while (!this.itemUpdateQueue.isEmpty()) {
            WeakReference<EntityItem> itemRef = this.itemUpdateQueue.pop();
            EntityItem item = (EntityItem)itemRef.get();
            if (item == null || !this.checkItemFilter(item)) continue;
            this.demagnetizeItem(item);
        }
        if (this.currTick == 4) {
            List list = this.field_145850_b.func_72872_a(EntityItem.class, this.scanArea);
            for (EntityItem item : list) {
                if (!this.checkItemFilter(item)) continue;
                this.demagnetizeItem(item);
            }
            this.currTick = 0;
        } else {
            ++this.currTick;
        }
    }

    boolean checkItem(EntityItem item) {
        if (this.redstoneUnpowered()) {
            return false;
        }
        if (this.scanArea != null && item != null) {
            AxisAlignedBB entityBox = item.func_174813_aQ();
            return this.scanArea.func_72326_a(entityBox) && this.checkItemFilter(item);
        }
        return false;
    }

    boolean queueItemClient(EntityItem item) {
        AxisAlignedBB entityBox;
        if (this.redstoneUnpowered()) {
            return false;
        }
        if (this.scanArea != null && item != null && this.scanArea.func_72326_a(entityBox = item.func_174813_aQ())) {
            this.itemUpdateQueue.push(new WeakReference<EntityItem>(item));
            return true;
        }
        return false;
    }

    void demagnetizeItem(EntityItem item) {
        NBTTagCompound data = item.getEntityData();
        if (!data.func_74767_n("PreventRemoteMovement")) {
            data.func_74757_a("PreventRemoteMovement", true);
        }
        if (!data.func_74767_n("AllowMachineRemoteMovement")) {
            data.func_74757_a("AllowMachineRemoteMovement", true);
        }
    }

    public void updateBlock() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    void updateRedstone(boolean redstoneStatus) {
        this.isPowered = redstoneStatus;
        this.updateBlock();
    }

    private boolean redstoneUnpowered() {
        switch (this.redstoneSetting) {
            case POWERED: {
                return !this.isPowered;
            }
            case UNPOWERED: {
                return this.isPowered;
            }
        }
        return false;
    }

    public int getFilterSize() {
        return ConfigHandler.demagnetizerFilterSlots;
    }

    private boolean checkItemFilter(EntityItem item) {
        if (item.func_92059_d().func_190926_b()) {
            if (!this.filtersWhitelist) {
                for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                    if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.filtersWhitelist) {
            return this.checkItemFilterMatches(item);
        }
        return !this.checkItemFilterMatches(item);
    }

    private boolean checkItemFilterMatches(EntityItem item) {
        ItemStack matchingItem = item.func_92059_d();
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if (i >= this.getFilterSize()) {
                return false;
            }
            ItemStack filterStack = this.itemStackHandler.getStackInSlot(i);
            if (filterStack.func_190926_b() || !filterStack.func_185136_b(matchingItem)) continue;
            return true;
        }
        return false;
    }

    boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    int getRange() {
        if (this.range > this.getMaxRange()) {
            this.range = this.getMaxRange();
        }
        if (this.range < 1) {
            this.range = 0;
        }
        return this.range;
    }

    RedstoneStatus getRedstoneSetting() {
        return this.redstoneSetting;
    }

    boolean isWhitelist() {
        return this.filtersWhitelist;
    }

    public void setRange(int range) {
        this.range = range;
        this.updateBoundingBox();
    }

    public void setRedstoneSetting(RedstoneStatus setting) {
        this.redstoneSetting = setting;
    }

    public void setWhitelist(boolean whitelist) {
        this.filtersWhitelist = whitelist;
    }

    void sendSettingsToServer() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDemagnetizerSettings(this.range, this.redstoneSetting, this.filtersWhitelist, this.func_174877_v()));
    }

    public static enum RedstoneStatus {
        REDSTONE_DISABLED,
        POWERED,
        UNPOWERED;

    }
}

