/*
 * Decompiled with CFR 0.152.
 */
package link.infra.demagnetize.blocks;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import link.infra.demagnetize.Demagnetize;
import link.infra.demagnetize.blocks.DemagnetizerTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Demagnetizer
extends Block
implements ITileEntityProvider {
    public Demagnetizer() {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new DemagnetizerTileEntity();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof DemagnetizerTileEntity)) {
            return false;
        }
        player.openGui((Object)Demagnetize.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(this.getRegistryName()), "inventory"));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof DemagnetizerTileEntity) {
            int powerLevel = worldIn.func_175687_A(pos);
            ((DemagnetizerTileEntity)te).updateRedstone(powerLevel > 0);
        }
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DemagnetizerTileEntity) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound tagCompound = new NBTTagCompound();
            ((DemagnetizerTileEntity)te).writeInternalNBT(tagCompound);
            stack.func_77982_d(tagCompound);
            drops.add((Object)stack);
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World worldIn, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof DemagnetizerTileEntity && stack.func_77978_p() != null) {
            ((DemagnetizerTileEntity)te).readInternalNBT(stack.func_77978_p());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77978_p() != null) {
            tooltip.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.demagnetize.configured.name", (Object[])new Object[0]) + TextFormatting.RESET);
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, World world, @Nonnull BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DemagnetizerTileEntity) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound tagCompound = new NBTTagCompound();
            ((DemagnetizerTileEntity)te).writeInternalNBT(tagCompound);
            stack.func_77982_d(tagCompound);
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }
}

