/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.docmanagement;

import com.brandon3055.projectintelligence.docmanagement.ContentRelation;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.DocumentationPage;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;

public class ModStructurePage
extends DocumentationPage {
    protected List<String> modAliases = new LinkedList<String>();
    protected Map<String, DocumentationPage> URIPageMap = new HashMap<String, DocumentationPage>();
    public boolean verified = false;

    protected ModStructurePage(DocumentationPage parent, String modid, String modVersion, boolean isPackDoc) {
        super(parent, modid, modVersion, isPackDoc);
    }

    @Override
    public File getMarkdownFile() {
        if (this.isPackDoc) {
            return new File(DocumentationManager.getPackDocDirectory(), this.modid + "/structure/" + this.getLocalizationLang() + "/" + this.markdownFile);
        }
        return new File(DocumentationManager.getDocDirectory(), this.modid + "/" + this.modVersion + "/structure/" + this.getLocalizationLang() + "/" + this.markdownFile);
    }

    @Override
    public String getPageId() {
        return this.getModid();
    }

    public List<String> getModAliases() {
        return this.modAliases;
    }

    private void generatePageURIs() {
        this.URIPageMap.clear();
        this.pageURI = this.modid + ":";
        this.URIPageMap.put(this.pageURI, this);
        this.subPages.forEach(documentationPage -> documentationPage.generatePageURIs(this.pageURI, this.URIPageMap));
    }

    public Map<String, DocumentationPage> getURIPageMap() {
        return this.URIPageMap;
    }

    public File getVersionDir() {
        if (this.isPackDoc) {
            return new File(DocumentationManager.getPackDocDirectory(), this.modid);
        }
        return new File(DocumentationManager.getDocDirectory(), this.modid + "/" + this.modVersion);
    }

    public File getStructureDir() {
        return new File(this.getVersionDir(), "structure");
    }

    @Nullable
    public static ModStructurePage generateFromJson(JsonObject jObj, boolean isPackDoc) {
        if (!JsonUtils.func_151205_a((JsonObject)jObj, (String)"mod_id") || !JsonUtils.func_151205_a((JsonObject)jObj, (String)"mod_version")) {
            return null;
        }
        ModStructurePage page = new ModStructurePage(null, JsonUtils.func_151200_h((JsonObject)jObj, (String)"mod_id"), JsonUtils.func_151200_h((JsonObject)jObj, (String)"mod_version"), isPackDoc);
        page.loadFromJson(jObj);
        return page;
    }

    @Override
    public void loadFromJson(JsonObject jObj) {
        this.verified = JsonUtils.func_151209_a((JsonObject)jObj, (String)"verified", (boolean)false);
        this.markdownFile = JsonUtils.func_151219_a((JsonObject)jObj, (String)"file", (String)"");
        if (JsonUtils.func_151202_d((JsonObject)jObj, (String)"mod_aliases")) {
            this.modAliases.clear();
            for (JsonElement element : JsonUtils.func_151214_t((JsonObject)jObj, (String)"mod_aliases")) {
                if (!JsonUtils.func_151211_a((JsonElement)element)) continue;
                this.modAliases.add(element.getAsJsonPrimitive().getAsString());
            }
        }
        if (JsonUtils.func_151202_d((JsonObject)jObj, (String)"relations")) {
            this.relations.clear();
            for (JsonElement element : JsonUtils.func_151214_t((JsonObject)jObj, (String)"relations")) {
                ContentRelation relation;
                if (!element.isJsonObject() || (relation = ContentRelation.fromJson(element.getAsJsonObject())) == null) continue;
                this.relations.add(relation);
            }
        }
        if (JsonUtils.func_151202_d((JsonObject)jObj, (String)"icons")) {
            this.icons.clear();
            for (JsonElement element : JsonUtils.func_151214_t((JsonObject)jObj, (String)"icons")) {
                if (!element.isJsonObject()) continue;
                this.icons.add(element.getAsJsonObject());
            }
        }
        this.cycle_icons = JsonUtils.func_151209_a((JsonObject)jObj, (String)"cycle_icons", (boolean)false);
        if (JsonUtils.func_151202_d((JsonObject)jObj, (String)"pages")) {
            this.loadSubPages(JsonUtils.func_151214_t((JsonObject)jObj, (String)"pages"));
        }
        this.generatePageURIs();
    }

    @Override
    public JsonObject writeToJson() {
        JsonArray array;
        JsonObject jObj = new JsonObject();
        jObj.addProperty("mod_id", this.modid);
        jObj.addProperty("mod_version", this.modVersion);
        jObj.addProperty("__verified_comment", "Do not change this to true. If you do so your PR will be automatically rejected.");
        jObj.addProperty("verified", Boolean.valueOf(false));
        jObj.addProperty("file", this.markdownFile);
        if (this.modAliases.size() > 0) {
            array = new JsonArray();
            for (String id : this.modAliases) {
                array.add((JsonElement)new JsonPrimitive(id));
            }
            jObj.add("mod_aliases", (JsonElement)array);
        }
        if (this.relations.size() > 0) {
            array = new JsonArray();
            for (ContentRelation relation : this.relations) {
                array.add((JsonElement)relation.toJson());
            }
            jObj.add("relations", (JsonElement)array);
        }
        if (this.icons.size() > 0) {
            array = new JsonArray();
            for (JsonObject icon : this.icons) {
                array.add((JsonElement)icon);
            }
            jObj.add("icons", (JsonElement)array);
        }
        jObj.addProperty("cycle_icons", Boolean.valueOf(this.cycle_icons));
        if (this.getSubPages().size() > 0) {
            JsonArray subPages = new JsonArray();
            this.writeSubPages(subPages);
            jObj.add("pages", (JsonElement)subPages);
        }
        return jObj;
    }

    @Override
    public void deletePage() {
    }
}

