/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.docmanagement;

import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.google.gson.JsonObject;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContentRelation {
    public final Type type;
    public final String contentString;
    public final boolean ignoreMeta;
    public final boolean includeNBT;
    private Object content = null;
    private boolean unavalible = false;

    public ContentRelation(Type type, String contentString, boolean ignoreMeta, boolean includeNBT) {
        this.type = type;
        this.contentString = contentString;
        this.ignoreMeta = ignoreMeta;
        this.includeNBT = includeNBT;
    }

    ContentRelation(JsonObject object) {
        this.type = Type.valueOf(object.get("type").getAsString());
        this.contentString = object.get("content").getAsString();
        this.ignoreMeta = JsonUtils.func_151209_a((JsonObject)object, (String)"ignore_meta", (boolean)false);
        this.includeNBT = JsonUtils.func_151209_a((JsonObject)object, (String)"include_nbt", (boolean)false);
    }

    @Nullable
    public Fluid getFluid() {
        if (this.unavalible || this.type != Type.FLUID) {
            return null;
        }
        if (this.content == null) {
            this.content = FluidRegistry.getFluid((String)this.contentString);
            if (this.content == null) {
                this.unavalible = true;
            }
        }
        return (Fluid)this.content;
    }

    @Nullable
    public ItemStack getStack() {
        if (this.unavalible || this.type != Type.STACK) {
            return null;
        }
        if (this.content == null) {
            this.loadStack();
        }
        return (ItemStack)this.content;
    }

    @Nullable
    public EntityEntry getEntity() {
        if (this.unavalible || this.type != Type.ENTITY) {
            return null;
        }
        if (this.content == null) {
            this.content = ForgeRegistries.ENTITIES.getValue(new ResourceLocation(this.contentString));
            if (this.content == null) {
                this.unavalible = true;
            }
        }
        return (EntityEntry)this.content;
    }

    private void loadStack() {
        StackReference reference = StackReference.fromString((String)this.contentString);
        if (reference != null) {
            this.content = reference.createStack();
            if (((ItemStack)this.content).func_190926_b()) {
                this.unavalible = true;
            }
        } else {
            this.unavalible = true;
        }
    }

    public boolean isMatch(ItemStack test) {
        ItemStack stack;
        if (this.type == Type.STACK && !this.unavalible && (stack = this.getStack()) != null) {
            if (stack.func_77973_b() != test.func_77973_b() || !this.ignoreMeta && stack.func_77952_i() != test.func_77952_i()) {
                return false;
            }
            return !this.includeNBT || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)test);
        }
        return false;
    }

    public boolean isMatch(Fluid test) {
        Fluid fluid;
        if (this.type == Type.FLUID && !this.unavalible && (fluid = this.getFluid()) != null) {
            return fluid.getName().equals(test.getName());
        }
        return false;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", this.type.name());
        obj.addProperty("content", this.contentString);
        if (this.ignoreMeta) {
            obj.addProperty("ignore_meta", Boolean.valueOf(true));
        }
        if (this.includeNBT) {
            obj.addProperty("include_nbt", Boolean.valueOf(true));
        }
        return obj;
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        if (this.unavalible) {
            return "";
        }
        switch (this.type) {
            case STACK: {
                ItemStack stack = this.getStack();
                if (stack == null) break;
                return stack.func_82833_r();
            }
            case ENTITY: {
                String name;
                EntityEntry entry = this.getEntity();
                if (entry == null || (name = EntityList.func_191302_a((ResourceLocation)entry.getRegistryName())) == null) break;
                return I18n.func_135052_a((String)name, (Object[])new Object[0]);
            }
            case FLUID: {
                Fluid fluid = this.getFluid();
                if (fluid == null) break;
                return fluid.getLocalizedName(new FluidStack(fluid, 1000));
            }
        }
        return "";
    }

    @Nullable
    public static ContentRelation fromJson(JsonObject object) {
        try {
            return new ContentRelation(object);
        }
        catch (Throwable e) {
            e.printStackTrace();
            PIGuiHelper.displayError("Failed to load content relation from: " + object + "\nSee console for stacktrace");
            return null;
        }
    }

    public String toString() {
        return this.type.name().toLowerCase(Locale.ENGLISH) + "|" + this.contentString + (this.type == Type.STACK ? ", ignMeta: " + this.ignoreMeta + ", incNBT: " + this.includeNBT : "");
    }

    public static enum Type {
        STACK,
        ENTITY,
        FLUID;

    }
}

