/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.keybinding;

import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.projectintelligence.ProjectIntelligence;
import com.brandon3055.projectintelligence.api.PiAPI;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class KeyInputHandler {
    public static KeyBinding openPI;
    public static KeyBinding etGUI;
    public static KeyBinding etWorld;

    public static void init() {
        openPI = new KeyBinding("pi.key.open_pi", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> openPI), 23, "Project Intelligence");
        etGUI = new KeyBinding("pi.key.et_gui", (IKeyConflictContext)new CustomContext(KeyConflictContext.GUI, () -> etGUI), 23, "Project Intelligence");
        etWorld = new KeyBinding("pi.key.et_world", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> etWorld), KeyModifier.CONTROL, 23, "Project Intelligence");
        ClientRegistry.registerKeyBinding((KeyBinding)openPI);
        ClientRegistry.registerKeyBinding((KeyBinding)etGUI);
        ClientRegistry.registerKeyBinding((KeyBinding)etWorld);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        this.onPress();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        this.onPress();
    }

    private void onPress() {
        if (etWorld.func_151468_f()) {
            this.handleWorldInfo();
        } else if (openPI.func_151468_f()) {
            ProjectIntelligence.proxy.openMainGui(null, null, null);
        }
    }

    private void handleWorldInfo() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        RayTraceResult mcResult = mc.field_71476_x;
        RayTraceResult ccResult = RayTracer.retrace((EntityPlayer)player, (boolean)PIConfig.etCheckFluid);
        RayTraceResult result = mcResult != null && mcResult.field_72313_a == RayTraceResult.Type.ENTITY ? mcResult : (ccResult != null && ccResult.field_72313_a != RayTraceResult.Type.MISS ? ccResult : (!PIConfig.etCheckFluid && (ccResult = RayTracer.retrace((EntityPlayer)player, (boolean)true)) != null && ccResult.field_72313_a != RayTraceResult.Type.MISS ? ccResult : mcResult));
        if (result == null || result.field_72313_a == RayTraceResult.Type.MISS) {
            ChatHelper.indexedMsg((ICommandSender)player, (String)I18n.func_135052_a((String)"pi.msg.et_miss", (Object[])new Object[0]));
            return;
        }
        switch (result.field_72313_a) {
            case BLOCK: {
                IBlockState state = mc.field_71441_e.func_180495_p(result.func_178782_a());
                Block block = state.func_177230_c();
                List<String> pages = null;
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
                if (fluid != null) {
                    pages = PiAPI.getRelatedPages(fluid);
                } else {
                    ItemStack stack = block.getPickBlock(state, result, (World)mc.field_71441_e, result.func_178782_a(), (EntityPlayer)player);
                    if (!stack.func_190926_b()) {
                        pages = PiAPI.getRelatedPages(stack);
                    }
                }
                if (pages == null || pages.isEmpty()) {
                    if (fluid != null) {
                        ChatHelper.indexedMsg((ICommandSender)player, (String)I18n.func_135052_a((String)"pi.msg.no_doc_found_for", (Object[])new Object[]{I18n.func_135052_a((String)fluid.getUnlocalizedName(), (Object[])new Object[0])}));
                        break;
                    }
                    ChatHelper.indexedMsg((ICommandSender)player, (String)I18n.func_135052_a((String)"pi.msg.no_doc_found_for", (Object[])new Object[]{I18n.func_135052_a((String)(Item.func_150898_a((Block)block).func_77658_a() + ".name"), (Object[])new Object[0])}));
                    break;
                }
                PiAPI.openGui(null, pages);
                break;
            }
            case ENTITY: {
                List<String> pages = PiAPI.getRelatedPages(EntityList.func_191301_a((Entity)result.field_72308_g) + "");
                if (pages.isEmpty()) {
                    ChatHelper.indexedMsg((ICommandSender)player, (String)I18n.func_135052_a((String)"pi.msg.no_doc_found_for", (Object[])new Object[]{result.field_72308_g.func_145748_c_().func_150254_d()}));
                    break;
                }
                PiAPI.openGui(null, pages);
            }
        }
    }

    private static class CustomContext
    implements IKeyConflictContext {
        private KeyConflictContext context;
        private Supplier<KeyBinding> binding;

        public CustomContext(KeyConflictContext context, Supplier<KeyBinding> binding) {
            this.context = context;
            this.binding = binding;
        }

        public boolean isActive() {
            return this.context.isActive();
        }

        public boolean conflicts(IKeyConflictContext other) {
            if (!(other instanceof CustomContext)) {
                return other == this.context;
            }
            if (((CustomContext)other).context != this.context) {
                return false;
            }
            KeyBinding otherBind = ((CustomContext)other).binding.get();
            return otherBind.func_151463_i() == this.binding.get().func_151463_i() && otherBind.getKeyModifier() == this.binding.get().getKeyModifier();
        }
    }
}

