/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui;

import codechicken.lib.colour.Colour;
import codechicken.lib.util.ArrayUtils;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.projectintelligence.docmanagement.ContentRelation;
import com.brandon3055.projectintelligence.utils.LogHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;

public class ContentInfo {
    public ContentType type;
    public StackReference stack = new StackReference(ItemStack.field_190927_a);
    public boolean drawHover = true;
    public String fluid = "water";
    public String entity = "minecraft:pig";
    public ItemStack[] entityInventory = new ItemStack[6];
    public int xOffset = 0;
    public int yOffset = 0;
    public double rotationSpeed = 1.0;
    public int rotation = 0;
    public double scale = 1.0;
    public boolean trackMouse = false;
    public boolean drawName = false;
    public boolean allowDrag = false;
    public String imageURL = "http://ss.brandon3055.com/iqx38ra.jpg";
    public Colour borderColour = null;
    public Colour borderColourHover = null;
    public int padding = 0;
    public int leftPadding = 0;
    public int rightPadding = 0;
    public int topPadding = 0;
    public int bottomPadding = 0;
    public int width = 18;
    public int height = -1;
    public int size = 18;
    public boolean sizePercent = false;
    public String hover_text = "";
    public boolean drawSlot = false;
    public String linkTarget = "";
    public boolean ignoreMeta = false;
    public boolean includeNBT = false;

    public ContentInfo(ContentType type) {
        this.type = type;
        ArrayUtils.fill((Object[])this.entityInventory, (Object)ItemStack.field_190927_a);
    }

    public JsonObject getAsIconObj() {
        JsonObject object = new JsonObject();
        object.addProperty("type", this.type.name);
        if (this.drawSlot) {
            object.addProperty("draw_slot", Boolean.valueOf(true));
        }
        if (!this.drawHover) {
            object.addProperty("draw_hover", Boolean.valueOf(false));
        }
        if (!this.hover_text.isEmpty()) {
            object.addProperty("hover_text", this.hover_text);
        }
        switch (this.type) {
            case ITEM_STACK: {
                object.addProperty("icon_string", this.stack.toString());
                break;
            }
            case ENTITY: {
                object.addProperty("icon_string", this.entity);
                if (this.trackMouse) {
                    object.addProperty("track_mouse", Boolean.valueOf(true));
                }
                LogHelper.dev(this.entityInventory[0]);
                JsonObject equip = new JsonObject();
                if (!this.entityInventory[0].func_190926_b()) {
                    equip.addProperty("main_hand", StackReference.stackString((ItemStack)this.entityInventory[0]));
                }
                if (!this.entityInventory[1].func_190926_b()) {
                    equip.addProperty("off_hand", StackReference.stackString((ItemStack)this.entityInventory[1]));
                }
                if (!this.entityInventory[2].func_190926_b()) {
                    equip.addProperty("head", StackReference.stackString((ItemStack)this.entityInventory[2]));
                }
                if (!this.entityInventory[3].func_190926_b()) {
                    equip.addProperty("chest", StackReference.stackString((ItemStack)this.entityInventory[3]));
                }
                if (!this.entityInventory[4].func_190926_b()) {
                    equip.addProperty("legs", StackReference.stackString((ItemStack)this.entityInventory[4]));
                }
                if (!this.entityInventory[5].func_190926_b()) {
                    equip.addProperty("feet", StackReference.stackString((ItemStack)this.entityInventory[5]));
                }
                if (equip.entrySet().isEmpty()) break;
                object.add("equipment", (JsonElement)equip);
                break;
            }
            case IMAGE: {
                object.addProperty("icon_string", this.imageURL);
            }
        }
        return object;
    }

    public static ContentInfo fromIconObj(JsonObject iconObj) {
        ContentInfo ci = new ContentInfo(ContentType.getByName(JsonUtils.func_151219_a((JsonObject)iconObj, (String)"type", (String)"stack")));
        ci.drawSlot = JsonUtils.func_151209_a((JsonObject)iconObj, (String)"draw_slot", (boolean)ci.drawSlot);
        ci.drawHover = JsonUtils.func_151209_a((JsonObject)iconObj, (String)"draw_hover", (boolean)ci.drawHover);
        ci.hover_text = JsonUtils.func_151219_a((JsonObject)iconObj, (String)"hover_text", (String)"");
        switch (ci.type) {
            case ITEM_STACK: {
                if (!JsonUtils.func_151204_g((JsonObject)iconObj, (String)"icon_string")) break;
                ci.stack = StackReference.fromString((String)JsonUtils.func_151219_a((JsonObject)iconObj, (String)"icon_string", (String)""));
                break;
            }
            case ENTITY: {
                ci.trackMouse = JsonUtils.func_151209_a((JsonObject)iconObj, (String)"track_mouse", (boolean)ci.trackMouse);
                if (JsonUtils.func_151204_g((JsonObject)iconObj, (String)"equipment") && iconObj.get("equipment").isJsonObject()) {
                    JsonObject equip = iconObj.get("equipment").getAsJsonObject();
                    if (JsonUtils.func_151204_g((JsonObject)equip, (String)"main_hand")) {
                        ci.entityInventory[0] = ContentInfo.getStack(JsonUtils.func_151219_a((JsonObject)equip, (String)"main_hand", (String)""));
                    }
                    if (JsonUtils.func_151204_g((JsonObject)equip, (String)"off_hand")) {
                        ci.entityInventory[1] = ContentInfo.getStack(JsonUtils.func_151219_a((JsonObject)equip, (String)"off_hand", (String)""));
                    }
                    if (JsonUtils.func_151204_g((JsonObject)equip, (String)"head")) {
                        ci.entityInventory[2] = ContentInfo.getStack(JsonUtils.func_151219_a((JsonObject)equip, (String)"head", (String)""));
                    }
                    if (JsonUtils.func_151204_g((JsonObject)equip, (String)"chest")) {
                        ci.entityInventory[3] = ContentInfo.getStack(JsonUtils.func_151219_a((JsonObject)equip, (String)"chest", (String)""));
                    }
                    if (JsonUtils.func_151204_g((JsonObject)equip, (String)"legs")) {
                        ci.entityInventory[4] = ContentInfo.getStack(JsonUtils.func_151219_a((JsonObject)equip, (String)"legs", (String)""));
                    }
                    if (JsonUtils.func_151204_g((JsonObject)equip, (String)"feet")) {
                        ci.entityInventory[5] = ContentInfo.getStack(JsonUtils.func_151219_a((JsonObject)equip, (String)"feet", (String)""));
                    }
                }
                if (!JsonUtils.func_151204_g((JsonObject)iconObj, (String)"icon_string")) break;
                ci.entity = JsonUtils.func_151219_a((JsonObject)iconObj, (String)"icon_string", (String)"");
                break;
            }
            case IMAGE: {
                if (!JsonUtils.func_151204_g((JsonObject)iconObj, (String)"icon_string")) break;
                ci.imageURL = JsonUtils.func_151219_a((JsonObject)iconObj, (String)"icon_string", (String)"");
            }
        }
        return ci;
    }

    public ContentRelation asRelation() {
        String contentString = "";
        switch (this.type) {
            case ITEM_STACK: {
                if (!this.includeNBT) {
                    this.stack.setNbt(null);
                }
                contentString = this.stack.toString();
                break;
            }
            case ENTITY: {
                contentString = this.entity;
                this.includeNBT = false;
                this.ignoreMeta = false;
                break;
            }
            case FLUID: {
                contentString = this.fluid;
                this.includeNBT = false;
                this.ignoreMeta = false;
            }
        }
        return new ContentRelation(ContentType.toRelationType(this.type), contentString, this.ignoreMeta, this.includeNBT);
    }

    public static ContentInfo fromRelation(ContentRelation relation) {
        ContentInfo info = new ContentInfo(ContentType.fromRelationType(relation.type));
        switch (relation.type) {
            case STACK: {
                info.stack = StackReference.fromString((String)relation.contentString);
                if (info.stack == null) {
                    info.stack = new StackReference(ItemStack.field_190927_a);
                }
                info.ignoreMeta = relation.ignoreMeta;
                info.includeNBT = relation.includeNBT;
                break;
            }
            case ENTITY: {
                info.entity = relation.contentString;
                break;
            }
            case FLUID: {
                info.fluid = relation.contentString;
            }
        }
        return info;
    }

    public String toMDTag() {
        String tag = "\u00a7" + this.type.name;
        String ops = "";
        switch (this.type) {
            case ITEM_STACK: {
                tag = tag + "[" + this.stack.toString() + "]";
                ops = this.addIf(ops, "size:" + this.size + (this.sizePercent ? "%" : ""), () -> true);
                ops = this.addIf(ops, "draw_slot:true", () -> this.drawSlot);
                ops = this.addIf(ops, "enable_tooltip:false", () -> !this.drawHover);
                ops = this.addIf(ops, "tooltip:\"" + this.hover_text.replace("\n", "\\n") + "\"", () -> !this.hover_text.isEmpty());
                break;
            }
            case ENTITY: {
                tag = tag + "[" + this.entity + "]";
                ops = this.addIf(ops, "size:" + this.size + (this.sizePercent ? "%" : ""), () -> true);
                ops = this.addIf(ops, "x_offset:" + this.xOffset, () -> this.xOffset > 0);
                ops = this.addIf(ops, "y_offset:" + this.yOffset, () -> this.yOffset > 0);
                ops = this.addIf(ops, "rotate_speed:" + this.rotationSpeed, () -> this.rotationSpeed != 1.0);
                ops = this.addIf(ops, "rotation:" + this.rotation, () -> this.rotation != 0);
                ops = this.addIf(ops, "scale:" + this.scale, () -> this.scale != 1.0);
                ops = this.addIf(ops, "tooltip:\"" + this.hover_text.replace("\n", "\\n") + "\"", () -> !this.hover_text.isEmpty());
                ops = this.addIf(ops, "track_mouse:true", () -> this.trackMouse);
                ops = this.addIf(ops, "draw_name:true", () -> this.drawName);
                ops = this.addIf(ops, "main_hand:\"" + this.getEquipString(0) + "\"", () -> !this.getEquipString(0).isEmpty());
                ops = this.addIf(ops, "off_hand:\"" + this.getEquipString(1) + "\"", () -> !this.getEquipString(1).isEmpty());
                ops = this.addIf(ops, "head:\"" + this.getEquipString(2) + "\"", () -> !this.getEquipString(2).isEmpty());
                ops = this.addIf(ops, "chest:\"" + this.getEquipString(3) + "\"", () -> !this.getEquipString(3).isEmpty());
                ops = this.addIf(ops, "legs:\"" + this.getEquipString(4) + "\"", () -> !this.getEquipString(4).isEmpty());
                ops = this.addIf(ops, "boots:\"" + this.getEquipString(5) + "\"", () -> !this.getEquipString(5).isEmpty());
                break;
            }
            case IMAGE: {
                tag = "\u00a7img[" + this.imageURL + "]";
                ops = this.addIf(ops, "border_colour:0x" + Integer.toHexString(this.borderColour == null ? 0 : this.borderColour.rgb()), () -> this.borderColour != null);
                ops = this.addIf(ops, "border_colour_hover:0x" + Integer.toHexString(this.borderColourHover == null ? 0 : this.borderColourHover.rgb()), () -> this.borderColourHover != null);
                if (this.leftPadding == this.rightPadding && this.topPadding == this.bottomPadding && this.leftPadding == this.topPadding) {
                    this.padding = this.leftPadding;
                    this.bottomPadding = 0;
                    this.topPadding = 0;
                    this.rightPadding = 0;
                    this.leftPadding = 0;
                }
                ops = this.addIf(ops, "padding:" + this.padding, () -> this.padding > 0);
                ops = this.addIf(ops, "left_pad:" + this.leftPadding, () -> this.leftPadding > 0);
                ops = this.addIf(ops, "right_pad:" + this.rightPadding, () -> this.rightPadding > 0);
                ops = this.addIf(ops, "top_pad:" + this.topPadding, () -> this.topPadding > 0);
                ops = this.addIf(ops, "bottom_pad:" + this.bottomPadding, () -> this.bottomPadding > 0);
                ops = this.addIf(ops, "width:" + this.width + (this.sizePercent ? "%" : ""), () -> this.width > 0);
                ops = this.addIf(ops, "height:" + this.height + (this.sizePercent ? "%" : ""), () -> this.height > 0);
                ops = this.addIf(ops, "tooltip:\"" + this.hover_text.replace("\n", "\\n") + "\"", () -> !this.hover_text.isEmpty());
                ops = this.addIf(ops, "link_to:\"" + this.linkTarget + "\"", () -> !this.linkTarget.isEmpty());
            }
        }
        return tag + (ops.isEmpty() ? "" : "{" + ops + "}");
    }

    private String getEquipString(int index) {
        if (!this.entityInventory[index].func_190926_b()) {
            return StackReference.stackString((ItemStack)this.entityInventory[index]);
        }
        return "";
    }

    public boolean hasEquipment() {
        for (ItemStack stack : this.entityInventory) {
            if (stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    private String getContentString() {
        switch (this.type) {
            case ENTITY: {
                return this.entity;
            }
            case IMAGE: {
                return this.imageURL;
            }
        }
        return this.stack.toString();
    }

    private static ItemStack getStack(String stackString) {
        StackReference ref = StackReference.fromString((String)stackString);
        if (ref == null) {
            return ItemStack.field_190927_a;
        }
        return ref.createStack();
    }

    private String addIf(String ops, Object add, Supplier<Boolean> check) {
        return ops + (check.get() != false ? (ops.isEmpty() ? "" : ",") + add : "");
    }

    public String toString() {
        return this.type.name + "|" + this.getContentString();
    }

    public static enum ContentType {
        ITEM_STACK("stack"),
        ENTITY("entity"),
        IMAGE("image"),
        FLUID("fluid");

        private final String name;

        private ContentType(String name) {
            this.name = name;
        }

        public static ContentType getByName(String name) {
            switch (name) {
                case "entity": {
                    return ENTITY;
                }
                case "image": {
                    return IMAGE;
                }
                case "fluid": {
                    return FLUID;
                }
            }
            return ITEM_STACK;
        }

        public static ContentType fromRelationType(ContentRelation.Type type) {
            switch (type) {
                case ENTITY: {
                    return ENTITY;
                }
                case FLUID: {
                    return FLUID;
                }
            }
            return ITEM_STACK;
        }

        public static ContentRelation.Type toRelationType(ContentType type) {
            switch (type) {
                case ITEM_STACK: {
                    return ContentRelation.Type.STACK;
                }
                case ENTITY: {
                    return ContentRelation.Type.ENTITY;
                }
                case FLUID: {
                    return ContentRelation.Type.FLUID;
                }
            }
            return ContentRelation.Type.ENTITY;
        }
    }
}

