/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util.catenation.persistence;

import com.google.common.collect.ImmutableMap;
import crafttweaker.api.data.DataInt;
import crafttweaker.api.data.DataList;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.DataString;
import crafttweaker.api.data.IData;
import crafttweaker.api.world.IWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.api.util.ExpandData;
import youyihj.zenutils.api.util.catenation.Catenation;
import youyihj.zenutils.api.util.catenation.CatenationContext;
import youyihj.zenutils.api.util.catenation.CatenationStatus;
import youyihj.zenutils.api.util.catenation.ICatenationTask;
import youyihj.zenutils.api.util.catenation.persistence.ICatenationFactory;
import youyihj.zenutils.api.util.catenation.persistence.ICatenationObjectHolder;
import youyihj.zenutils.api.world.ZenUtilsWorld;
import youyihj.zenutils.impl.util.catenation.persistence.CatenationPersistedObjects;
import youyihj.zenutils.impl.util.catenation.persistence.ObjectHolderTypeRegistry;

public class CatenationPersistenceImpl {
    private static final Map<String, Entry> persistData = new HashMap<String, Entry>();
    private static final Set<Catenation> waitingCatenation = new HashSet<Catenation>();

    public static void registerPersistCatenation(String key, ICatenationFactory catenationFactory, Map<String, ICatenationObjectHolder.Type<?>> objectHolderTypes) {
        persistData.put(key, new Entry(catenationFactory, (Map<String, ICatenationObjectHolder.Type<?>>)ImmutableMap.copyOf(objectHolderTypes)));
    }

    public static Catenation startCatenation(IWorld world, String key, CatenationPersistedObjects objects) {
        if (!persistData.containsKey(key)) {
            throw new IllegalArgumentException("No such persisted catenation registered: " + key);
        }
        Entry entry = persistData.get(key);
        entry.verify(objects);
        Catenation catenation = entry.getCatenationFactory().get(world);
        Map<ICatenationObjectHolder.Key<?>, ICatenationObjectHolder<?>> objectHolders = catenation.getContext().getObjectHolders();
        objects.getObjects().forEach((objKey, obj) -> {
            ICatenationObjectHolder<Object> holder = objKey.getType().createHolder();
            holder.setValue(obj);
            objectHolders.put((ICatenationObjectHolder.Key<?>)objKey, holder);
        });
        catenation.setPersistenceKey(key);
        return catenation;
    }

    public static IData serialize(Catenation catenation) {
        CatenationContext context = catenation.getContext();
        HashMap<String, Object> total = new HashMap<String, Object>();
        total.put("key", new DataString(catenation.getPersistenceKey()));
        Queue<ICatenationTask> tasks = catenation.getTasks();
        total.put("taskCount", new DataInt(tasks.size()));
        total.put("taskData", tasks.element().serializeToData());
        if (context.hasData()) {
            total.put("data", context.getData());
        }
        HashMap objData = new HashMap();
        Map<ICatenationObjectHolder.Key<?>, ICatenationObjectHolder<?>> objectHolders = context.getObjectHolders();
        objectHolders.forEach((key, objHolder) -> {
            HashMap<String, Object> objDataSingle = new HashMap<String, Object>();
            objDataSingle.put("type", new DataString(objHolder.getType().getValueType().getName()));
            objDataSingle.put("value", objHolder.serializeToData());
            objData.put(key.getKey(), new DataMap(objDataSingle, true));
        });
        total.put("objects", new DataMap(objData, true));
        return new DataMap(total, true);
    }

    public static Catenation deserialize(IData data, IWorld world) throws DeserializationException {
        String persistKey = data.memberGet("key").asString();
        Entry persistEntry = persistData.get(persistKey);
        Catenation catenation = persistEntry.getCatenationFactory().get(world);
        catenation.getContext().setStatus(CatenationStatus.SERIAL, world);
        catenation.setPersistenceKey(persistKey);
        Queue<ICatenationTask> tasks = catenation.getTasks();
        int toRemoveTasks = tasks.size() - data.memberGet("taskCount").asInt();
        try {
            for (int i = 0; i < toRemoveTasks; ++i) {
                tasks.remove();
            }
            tasks.element().deserializeFromData(data.memberGet("taskData"));
            if (tasks.element().isComplete()) {
                tasks.remove();
            }
        }
        catch (NoSuchElementException e) {
            throw new DeserializationException("Too few tasks. At least: " + toRemoveTasks);
        }
        if (data.contains((IData)new DataString("data"))) {
            catenation.getContext().setData(data.memberGet("data"));
        }
        Map objData = data.memberGet("objects").asMap();
        persistEntry.checkObjData(objData);
        Map<ICatenationObjectHolder.Key<?>, ICatenationObjectHolder<?>> objectHolders = catenation.getContext().getObjectHolders();
        objData.forEach((key, value) -> {
            ICatenationObjectHolder.Type<?> holderType = ObjectHolderTypeRegistry.get(value.memberGet("type").asString());
            ICatenationObjectHolder.Key<?> holderKey = ICatenationObjectHolder.Key.of(key, holderType);
            ICatenationObjectHolder<?> holder = holderType.createHolder();
            holder.deserializeFromData(value.memberGet("value"));
            objectHolders.put(holderKey, holder);
        });
        catenation.setWorld(world);
        return catenation;
    }

    public static void loadCatenations(IWorld world) {
        IData catenationsData = ZenUtilsWorld.getCustomWorldData(world).memberGet("catenations");
        if (catenationsData == null) {
            return;
        }
        for (IData catenationData : catenationsData.asList()) {
            Catenation catenation;
            try {
                catenation = CatenationPersistenceImpl.deserialize(catenationData, world);
            }
            catch (DeserializationException e) {
                ZenUtils.forgeLogger.error("Failed to read catenation from data " + catenationData.asString() + ". The catenation format maybe changed?", (Throwable)e);
                continue;
            }
            if (catenation.isAllObjectsValid()) {
                catenation.getContext().setStatus(CatenationStatus.WORKING, world);
                continue;
            }
            CatenationPersistenceImpl.addWaitingCatenation(catenation);
        }
    }

    public static void saveCatenations(IWorld world, List<Catenation> unfinished) {
        ArrayList<IData> catenationDataList = new ArrayList<IData>();
        for (Catenation catenation : unfinished) {
            if (catenation.getPersistenceKey() == null) continue;
            catenationDataList.add(CatenationPersistenceImpl.serialize(catenation));
        }
        HashMap<String, DataList> newCatenationDataMap = new HashMap<String, DataList>();
        newCatenationDataMap.put("catenations", new DataList(catenationDataList, true));
        DataMap newCatenationData = new DataMap(newCatenationDataMap, true);
        HashMap<String, IData> operationMap = new HashMap<String, IData>();
        operationMap.put("catenations", ExpandData.DataUpdateOperation.OVERWRITE);
        DataMap operationData = new DataMap(operationMap, true);
        ZenUtilsWorld.setCustomWorldData(world, ExpandData.deepUpdate(ZenUtilsWorld.getCustomWorldData(world), (IData)newCatenationData, (IData)operationData));
    }

    public static <T> void receiveObject(ICatenationObjectHolder.Type<T> type, T object) {
        Iterator<Catenation> iterator = waitingCatenation.iterator();
        while (iterator.hasNext()) {
            Catenation catenation = iterator.next();
            for (Map.Entry<ICatenationObjectHolder.Key<?>, ICatenationObjectHolder<?>> holderEntry : catenation.getContext().getObjectHolders().entrySet()) {
                if (!type.equals(holderEntry.getKey().getType())) continue;
                holderEntry.getValue().receiveObject(object);
            }
            if (!catenation.isAllObjectsValid()) continue;
            catenation.getContext().setStatus(CatenationStatus.WORKING, catenation.getWorld());
            iterator.remove();
        }
    }

    public static void addWaitingCatenation(Catenation catenation) {
        waitingCatenation.add(catenation);
    }

    public static class DeserializationException
    extends Exception {
        public DeserializationException(String message) {
            super(message);
        }
    }

    public static class Entry {
        private final ICatenationFactory catenationFactory;
        private final Map<String, ICatenationObjectHolder.Type<?>> objectHolderTypes;

        public Entry(ICatenationFactory catenationFactory, Map<String, ICatenationObjectHolder.Type<?>> objectHolderTypes) {
            this.catenationFactory = catenationFactory;
            this.objectHolderTypes = objectHolderTypes;
        }

        public ICatenationFactory getCatenationFactory() {
            return this.catenationFactory;
        }

        public void verify(CatenationPersistedObjects objects) {
            Set<ICatenationObjectHolder.Key<?>> dataKeys = objects.getObjects().keySet();
            for (Map.Entry<String, ICatenationObjectHolder.Type<?>> entry : this.objectHolderTypes.entrySet()) {
                String key = entry.getKey();
                boolean found = false;
                for (ICatenationObjectHolder.Key<?> dataKey : dataKeys) {
                    Class<?> given;
                    if (!key.equals(dataKey.getKey())) continue;
                    found = true;
                    Class<?> expected = entry.getValue().getValueType();
                    if (expected.equals(given = dataKey.getType().getValueType())) break;
                    throw new IllegalArgumentException("Type mismatches at key " + key + ", expected " + expected + ", but given " + given);
                }
                if (found) continue;
                throw new IllegalArgumentException("catenation object: {key: " + key + ", type: " + entry.getValue().getValueType().getName() + "} is missing.");
            }
        }

        public void checkObjData(Map<String, IData> objectsData) throws DeserializationException {
            for (Map.Entry<String, IData> entry : objectsData.entrySet()) {
                String key = entry.getKey();
                IData value = entry.getValue();
                ICatenationObjectHolder.Type<?> type = this.objectHolderTypes.get(key);
                if (type == null) {
                    throw new DeserializationException("Extra object key: " + key);
                }
                if (type.getValueType().getName().equals(value.memberGet("type").asString())) continue;
                throw new DeserializationException("Type mismatches at key " + key);
            }
            for (String key : this.objectHolderTypes.keySet()) {
                if (objectsData.containsKey(key)) continue;
                throw new DeserializationException("Catenation object " + key + " is missing.");
            }
        }
    }
}

