/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util.catenation;

import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nullable;
import youyihj.zenutils.api.util.catenation.Catenation;
import youyihj.zenutils.api.util.catenation.ICatenationBuilder;
import youyihj.zenutils.api.util.catenation.ICatenationTask;
import youyihj.zenutils.api.util.catenation.ITimerHandler;
import youyihj.zenutils.api.util.catenation.IWorldCondition;
import youyihj.zenutils.api.util.catenation.IWorldFunction;
import youyihj.zenutils.impl.util.catenation.InstantTask;
import youyihj.zenutils.impl.util.catenation.SleepTask;
import youyihj.zenutils.impl.util.catenation.SleepUntilTask;
import youyihj.zenutils.impl.util.catenation.TimerTask;

public abstract class AbstractCatenationBuilder
implements ICatenationBuilder {
    protected final Queue<ICatenationTask> tasks = new ArrayDeque<ICatenationTask>();
    @Nullable
    protected IWorldCondition stopWhen;
    @Nullable
    protected IWorldFunction onStop;

    @Override
    public ICatenationBuilder addTask(ICatenationTask task) {
        this.tasks.add(task);
        return this;
    }

    @Override
    public ICatenationBuilder run(IWorldFunction function) {
        return this.addTask(new InstantTask(function));
    }

    @Override
    public ICatenationBuilder sleep(long ticks) {
        return this.addTask(new SleepTask(ticks));
    }

    @Override
    public ICatenationBuilder sleepUntil(IWorldCondition condition) {
        return this.addTask(new SleepUntilTask(condition));
    }

    @Override
    public ICatenationBuilder customTimer(long duration, ITimerHandler handler) {
        return this.addTask(new TimerTask(duration, handler));
    }

    @Override
    public ICatenationBuilder stopWhen(IWorldCondition condition) {
        this.stopWhen = condition;
        return this;
    }

    @Override
    public ICatenationBuilder onStop(IWorldFunction function) {
        this.onStop = function;
        return this;
    }

    protected Catenation build() {
        return new Catenation(this.tasks, this.stopWhen, this.onStop);
    }

    protected abstract void register(Catenation var1);

    @Override
    public Catenation start() {
        Catenation catenation = this.build();
        this.register(catenation);
        return catenation;
    }
}

