/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.runtime;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.network.NetworkSide;
import crafttweaker.preprocessor.PreprocessorManager;
import crafttweaker.runtime.IScriptProvider;
import crafttweaker.runtime.ITweaker;
import crafttweaker.runtime.ScriptLoader;
import crafttweaker.runtime.events.CrTLoaderLoadingEvent;
import crafttweaker.runtime.events.CrTScriptLoadingEvent;
import crafttweaker.util.IEventHandler;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import youyihj.zenutils.api.reload.ActionReloadCallback;
import youyihj.zenutils.api.reload.IActionReloadCallbackFactory;
import youyihj.zenutils.api.reload.Reloadable;
import youyihj.zenutils.impl.reload.AnnotatedActionReloadCallback;
import youyihj.zenutils.impl.runtime.ScriptStatus;
import youyihj.zenutils.impl.util.InternalUtils;

public class ZenUtilsTweaker
implements ITweaker {
    private final ITweaker tweaker;
    private boolean freeze = false;
    private final Queue<ActionReloadCallback<?>> reloadableActions = new ArrayDeque();
    private final Map<Class<?>, IActionReloadCallbackFactory<?>> reloadCallbacks = new HashMap();

    public ZenUtilsTweaker(ITweaker tweaker) {
        this.tweaker = tweaker;
    }

    public void apply(IAction action) {
        boolean reloadable;
        ActionReloadCallback<IAction> reloadCallback = this.getReloadCallback(action);
        boolean bl = reloadable = reloadCallback != null;
        if (!this.freeze) {
            if (this.validateAction(action)) {
                return;
            }
            try {
                if (reloadable) {
                    reloadCallback.beforeApply(false);
                }
                action.apply();
                if (reloadable) {
                    reloadCallback.afterApply(false);
                }
            }
            catch (Throwable e) {
                CraftTweakerAPI.logError((String)"Failed to apply this action", (Throwable)e);
            }
        } else if (reloadable) {
            if (this.validateAction(action)) {
                return;
            }
            try {
                reloadCallback.beforeApply(true);
                reloadCallback.applyReload();
                reloadCallback.afterApply(true);
            }
            catch (Throwable e) {
                CraftTweakerAPI.logError((String)"Failed to apply this action", (Throwable)e);
            }
        } else {
            String describe = action.describe();
            if (describe != null && !describe.isEmpty()) {
                CraftTweakerAPI.logInfo((String)("Tried to reload action: " + describe + ", which is not reloadable."));
            } else {
                CraftTweakerAPI.logInfo((String)("Tried to reload an un-reloadable action: " + action));
            }
        }
        if (reloadable && reloadCallback.hasUndoMethod()) {
            this.reloadableActions.add(reloadCallback);
        }
    }

    public void setScriptProvider(IScriptProvider provider) {
        this.tweaker.setScriptProvider(provider);
    }

    public void load() {
        this.tweaker.load();
    }

    public boolean loadScript(boolean isSyntaxCommand, String loaderName) {
        ScriptStatus origin = InternalUtils.getScriptStatus();
        if (isSyntaxCommand) {
            InternalUtils.setScriptStatus(ScriptStatus.SYNTAX);
        }
        boolean result = this.tweaker.loadScript(isSyntaxCommand, loaderName);
        if (isSyntaxCommand) {
            InternalUtils.setScriptStatus(origin);
        }
        return result;
    }

    public void loadScript(boolean isSyntaxCommand, ScriptLoader loader) {
        ScriptStatus origin = InternalUtils.getScriptStatus();
        if (isSyntaxCommand) {
            InternalUtils.setScriptStatus(ScriptStatus.SYNTAX);
        }
        this.tweaker.loadScript(isSyntaxCommand, loader);
        if (isSyntaxCommand) {
            InternalUtils.setScriptStatus(origin);
        }
    }

    public List<IAction> getActions() {
        return this.tweaker.getActions();
    }

    public void enableDebug() {
        this.tweaker.enableDebug();
    }

    public PreprocessorManager getPreprocessorManager() {
        return this.tweaker.getPreprocessorManager();
    }

    public NetworkSide getNetworkSide() {
        return this.tweaker.getNetworkSide();
    }

    public void setNetworkSide(NetworkSide networkSide) {
        this.tweaker.setNetworkSide(networkSide);
    }

    public void registerLoadStartedEvent(IEventHandler<CrTLoaderLoadingEvent.Started> eventHandler) {
        this.tweaker.registerLoadStartedEvent(eventHandler);
    }

    public void registerLoadFinishedEvent(IEventHandler<CrTLoaderLoadingEvent.Finished> eventHandler) {
        this.tweaker.registerLoadFinishedEvent(eventHandler);
    }

    public void registerLoadAbortedEvent(IEventHandler<CrTLoaderLoadingEvent.Aborted> eventHandler) {
        this.tweaker.registerLoadAbortedEvent(eventHandler);
    }

    public void registerScriptLoadPreEvent(IEventHandler<CrTScriptLoadingEvent.Pre> eventHandler) {
        this.tweaker.registerScriptLoadPreEvent(eventHandler);
    }

    public void registerScriptLoadPostEvent(IEventHandler<CrTScriptLoadingEvent.Post> eventHandler) {
        this.tweaker.registerScriptLoadPostEvent(eventHandler);
    }

    public List<ScriptLoader> getLoaders() {
        return this.tweaker.getLoaders();
    }

    public ScriptLoader getOrCreateLoader(String ... nameAndAliases) {
        return this.tweaker.getOrCreateLoader(nameAndAliases);
    }

    public void freezeActionApplying() {
        this.freeze = true;
    }

    public ITweaker getITweaker() {
        return this.tweaker;
    }

    public void rollbackChanges() {
        while (!this.reloadableActions.isEmpty()) {
            ActionReloadCallback<?> action = this.reloadableActions.poll();
            try {
                action.undo();
            }
            catch (Throwable e) {
                CraftTweakerAPI.logError((String)("Failed to undo action " + action.describeAction()), (Throwable)e);
            }
        }
    }

    public Queue<ActionReloadCallback<?>> getReloadableActions() {
        return this.reloadableActions;
    }

    public <T extends IAction> void addReloadCallback(Class<T> clazz, IActionReloadCallbackFactory<T> callback) {
        this.reloadCallbacks.put(clazz, callback);
    }

    private boolean validateAction(IAction action) {
        if (!action.validate()) {
            CraftTweakerAPI.logError((String)"Action could not be applied", (Throwable)new UnsupportedOperationException(action.describeInvalid()));
            return true;
        }
        String describe = action.describe();
        if (describe != null && !describe.isEmpty()) {
            CraftTweakerAPI.logInfo((String)describe);
        }
        return false;
    }

    private ActionReloadCallback<IAction> getReloadCallback(IAction action) {
        Class<?> clazz = action.getClass();
        while (IAction.class.isAssignableFrom(clazz)) {
            if (this.reloadCallbacks.containsKey(clazz)) {
                return this.reloadCallbacks.get(clazz).create(action);
            }
            if (clazz.isAnnotationPresent(Reloadable.class)) {
                this.reloadCallbacks.put(clazz, AnnotatedActionReloadCallback::new);
                return new AnnotatedActionReloadCallback(action);
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }
}

