/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.reload;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.api.event.MTEventManager;
import crafttweaker.mc1120.entity.MCEntityDefinition;
import crafttweaker.util.EventList;
import crafttweaker.util.IEventHandler;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.api.cotx.brackets.LateGetContentLookup;
import youyihj.zenutils.api.reload.ScriptReloadEvent;
import youyihj.zenutils.api.util.ZenUtilsGlobal;
import youyihj.zenutils.impl.entity.EntityTickDispatcher;
import youyihj.zenutils.impl.util.InternalUtils;
import youyihj.zenutils.impl.util.ReflectUtils;

@Mod.EventBusSubscriber
public class ReloadEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onReloadPre(ScriptReloadEvent.Pre event) {
        InternalUtils.getAllEventLists().forEach(EventList::clear);
        ReloadEventHandler.reRegisterInternalEvents();
        ReloadEventHandler.refreshEntityDrops();
        ZenUtilsGlobal.addRegexLogFilter("Recipe name \\[.*\\] has duplicate uses, defaulting to calculated hash!");
        int reloadActionCount = ZenUtils.tweaker.getReloadableActions().size();
        if (reloadActionCount != 0) {
            event.getRequester().func_145747_a((ITextComponent)new TextComponentString(reloadActionCount + " actions reloaded."));
        }
        ZenUtils.tweaker.rollbackChanges();
        EntityTickDispatcher.clearCatenationFactories();
    }

    @SubscribeEvent
    public static void onReloadPost(ScriptReloadEvent.Post event) {
        if (InternalUtils.isContentTweakerInstalled()) {
            LateGetContentLookup.refreshFields();
            LateGetContentLookup.clear();
        }
        EntityTickDispatcher.restartCatenations();
    }

    private static void reRegisterInternalEvents() {
        try {
            Field listenLogin = ReflectUtils.removePrivate(CrafttweakerImplementationAPI.class, "LISTEN_LOGIN");
            Field listenLogout = ReflectUtils.removePrivate(CrafttweakerImplementationAPI.class, "LISTEN_LOGOUT");
            MTEventManager events = CrafttweakerImplementationAPI.events;
            events.onPlayerLoggedIn((IEventHandler)listenLogin.get(null));
            events.onPlayerLoggedOut((IEventHandler)listenLogout.get(null));
            events.onPlayerInteract((IEventHandler)CrafttweakerImplementationAPI.LISTEN_BLOCK_INFO);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private static void refreshEntityDrops() {
        List entityDefinitions = CraftTweakerAPI.game.getEntities();
        entityDefinitions.clear();
        ForgeRegistries.ENTITIES.forEach(it -> entityDefinitions.add(new MCEntityDefinition(it)));
    }
}

