/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.network;

import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.mc1120.world.MCBlockPos;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import youyihj.zenutils.api.network.IByteBuf;
import youyihj.zenutils.api.util.CrTUUID;
import youyihj.zenutils.impl.network.ByteAndDataConverter;

public class ZenUtilsByteBuf
implements IByteBuf {
    private final ByteBuf buf;

    public ZenUtilsByteBuf(ByteBuf buf) {
        this.buf = buf;
    }

    @Override
    public void writeBoolean(boolean value) {
        this.buf.writeBoolean(value);
    }

    @Override
    public void writeInt(int value) {
        this.buf.writeInt(value);
    }

    @Override
    public void writeByte(byte value) {
        this.buf.writeByte((int)value);
    }

    @Override
    public void writeLong(long value) {
        this.buf.writeLong(value);
    }

    @Override
    public void writeFloat(float value) {
        this.buf.writeFloat(value);
    }

    @Override
    public void writeDouble(double value) {
        this.buf.writeDouble(value);
    }

    @Override
    public void writeString(String string) {
        this.buf.writeInt(string.length());
        this.buf.writeCharSequence((CharSequence)string, StandardCharsets.UTF_8);
    }

    @Override
    public void writeItemStack(IItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            this.buf.writeByte(-1);
            return;
        }
        this.buf.writeByte(0);
        ItemStack mcStack = CraftTweakerMC.getItemStack((IItemStack)itemStack);
        this.writeString(mcStack.func_77973_b().getRegistryName().toString());
        this.writeInt(mcStack.func_190916_E());
        this.writeInt(mcStack.func_77952_i());
        this.writeData(itemStack.getTag());
    }

    @Override
    public void writeBlockPos(IBlockPos pos) {
        this.buf.writeInt(pos.getX());
        this.buf.writeInt(pos.getY());
        this.buf.writeInt(pos.getZ());
    }

    @Override
    public void writeData(IData data) {
        ByteAndDataConverter.writeDataToBytes(this, data);
    }

    @Override
    public void writeUUID(CrTUUID uuid) {
        this.buf.writeLong(uuid.getMostSignificantBits());
        this.buf.writeLong(uuid.getLeastSignificantBits());
    }

    @Override
    public boolean readBoolean() {
        return this.buf.readBoolean();
    }

    @Override
    public int readInt() {
        return this.buf.readInt();
    }

    @Override
    public byte readByte() {
        return this.buf.readByte();
    }

    @Override
    public long readLong() {
        return this.buf.readLong();
    }

    @Override
    public float readFloat() {
        return this.buf.readFloat();
    }

    @Override
    public double readDouble() {
        return this.buf.readDouble();
    }

    @Override
    public String readString() {
        int length = this.buf.readInt();
        return this.buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
    }

    @Override
    public IBlockPos readBlockPos() {
        return new MCBlockPos(this.buf.readInt(), this.buf.readInt(), this.buf.readInt());
    }

    @Override
    public IItemStack readItemStack() {
        if (this.readByte() == -1) {
            return null;
        }
        String name = this.readString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            return null;
        }
        ItemStack mcStack = new ItemStack(item, this.readInt(), this.readInt());
        IItemStack itemStack = CraftTweakerMC.getIItemStack((ItemStack)mcStack);
        return itemStack.withTag(this.readData(), true);
    }

    @Override
    public IData readData() {
        return ByteAndDataConverter.readDataFromBytes(this);
    }

    @Override
    public CrTUUID readUUID() {
        return new CrTUUID(new UUID(this.buf.readLong(), this.buf.readLong()));
    }

    @Override
    public ByteBuf getInternal() {
        return this.buf;
    }
}

