/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.util.catenation.persistence;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import youyihj.zenutils.api.util.catenation.Catenation;
import youyihj.zenutils.api.util.catenation.persistence.BuiltinObjectHolderTypes;
import youyihj.zenutils.api.util.catenation.persistence.ICatenationObjectHolder;
import youyihj.zenutils.impl.util.catenation.persistence.CatenationPersistedObjects;
import youyihj.zenutils.impl.util.catenation.persistence.CatenationPersistenceImpl;

@ZenRegister
@ZenClass(value="mods.zenutils.PersistedCatenationStarter")
public class PersistedCatenationStarter {
    private final IWorld world;
    private final String key;
    private final CatenationPersistedObjects objects = new CatenationPersistedObjects();

    public PersistedCatenationStarter(IWorld world, String key) {
        this.world = world;
        this.key = key;
    }

    public <T> PersistedCatenationStarter with(String key, ICatenationObjectHolder.Type<T> type, T object) {
        this.objects.with(key, type, object);
        return this;
    }

    @ZenMethod
    public Catenation start() {
        return CatenationPersistenceImpl.startCatenation(this.world, this.key, this.objects);
    }

    @ZenMethod
    public PersistedCatenationStarter withPlayer(IPlayer player, @Optional(value="player") String key) {
        return this.with(key, BuiltinObjectHolderTypes.PLAYER, player);
    }

    @ZenMethod
    public PersistedCatenationStarter withPosition(IBlockPos pos, @Optional(value="pos") String key) {
        return this.with(key, BuiltinObjectHolderTypes.POSITION, pos);
    }

    @ZenMethod
    public PersistedCatenationStarter withData(IData data, @Optional(value="data") String key) {
        return this.with(key, BuiltinObjectHolderTypes.DATA, data);
    }

    @ZenMethod
    public PersistedCatenationStarter withEntity(IEntity entity, @Optional(value="entity") String key) {
        return this.with(key, BuiltinObjectHolderTypes.ENTITY, entity);
    }
}

