/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.util.catenation.persistence;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import java.util.HashMap;
import java.util.Map;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import youyihj.zenutils.api.util.catenation.persistence.BuiltinObjectHolderTypes;
import youyihj.zenutils.api.util.catenation.persistence.CatenationPersistenceRegisterAction;
import youyihj.zenutils.api.util.catenation.persistence.ICatenationFactory;
import youyihj.zenutils.api.util.catenation.persistence.ICatenationObjectHolder;

@ZenRegister
@ZenClass(value="mods.zenutils.CatenationPersistenceEntryBuilder")
public class CatenationPersistenceEntryBuilder {
    private final String key;
    private final Map<String, ICatenationObjectHolder.Type<?>> objectHolderTypes = new HashMap();
    private ICatenationFactory catenationFactory;

    public CatenationPersistenceEntryBuilder(String key) {
        this.key = key;
    }

    public CatenationPersistenceEntryBuilder addObjectHolder(String objectKey, ICatenationObjectHolder.Type<?> type) {
        this.objectHolderTypes.put(objectKey, type);
        return this;
    }

    @ZenMethod
    public CatenationPersistenceEntryBuilder setCatenationFactory(ICatenationFactory catenationFactory) {
        this.catenationFactory = catenationFactory;
        return this;
    }

    @ZenMethod
    public void register() {
        if (this.catenationFactory == null) {
            throw new IllegalArgumentException("CatenationFactory is not settle.");
        }
        CraftTweakerAPI.apply((IAction)new CatenationPersistenceRegisterAction(this.key, this.objectHolderTypes, this.catenationFactory));
    }

    @ZenMethod
    public CatenationPersistenceEntryBuilder addPlayerHolder(@Optional(value="player") String objectKey) {
        return this.addObjectHolder(objectKey, BuiltinObjectHolderTypes.PLAYER);
    }

    @ZenMethod
    public CatenationPersistenceEntryBuilder addPositionHolder(@Optional(value="pos") String objectKey) {
        return this.addObjectHolder(objectKey, BuiltinObjectHolderTypes.POSITION);
    }

    @ZenMethod
    public CatenationPersistenceEntryBuilder addDataHolder(@Optional(value="data") String objectKey) {
        return this.addObjectHolder(objectKey, BuiltinObjectHolderTypes.DATA);
    }

    @ZenMethod
    public CatenationPersistenceEntryBuilder addEntityHolder(@Optional(value="entity") String objectKey) {
        return this.addObjectHolder(objectKey, BuiltinObjectHolderTypes.ENTITY);
    }
}

