/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.util.catenation;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.world.IWorld;
import java.util.Comparator;
import java.util.Queue;
import javax.annotation.Nullable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import youyihj.zenutils.api.util.catenation.CatenationContext;
import youyihj.zenutils.api.util.catenation.CatenationStatus;
import youyihj.zenutils.api.util.catenation.ICatenationTask;
import youyihj.zenutils.api.util.catenation.IWorldCondition;
import youyihj.zenutils.api.util.catenation.IWorldFunction;
import youyihj.zenutils.api.util.catenation.persistence.ICatenationObjectHolder;

@ZenRegister
@ZenClass(value="mods.zenutils.Catenation")
public class Catenation {
    private final Queue<ICatenationTask> tasks;
    @Nullable
    private final IWorldCondition stopWhen;
    private final CatenationContext context;
    private IWorld world;
    @Nullable
    private String persistenceKey;

    public Catenation(Queue<ICatenationTask> tasks, @Nullable IWorldCondition stopWhen, @Nullable IWorldFunction onStop) {
        this.tasks = tasks;
        this.stopWhen = stopWhen;
        this.context = new CatenationContext(this, onStop);
    }

    @ZenMethod
    public boolean tick(IWorld world) {
        this.setWorld(world);
        if (this.isStopped()) {
            return true;
        }
        this.context.checkObjectHolders();
        if (this.context.getStatus() == CatenationStatus.WORKING) {
            if (this.stopWhen != null) {
                try {
                    if (this.stopWhen.apply(world, this.context)) {
                        this.context.setStatus(CatenationStatus.STOP_INTERNAL, world);
                    }
                }
                catch (Throwable exception) {
                    CraftTweakerAPI.logError((String)"Exception occurred in stopWhen function, stopping the catenation...", (Throwable)exception);
                    this.context.setStatus(CatenationStatus.ERROR, world);
                }
            }
            if (this.isStopped()) {
                return true;
            }
            ICatenationTask task = this.tasks.peek();
            if (task == null) {
                this.context.setStatus(CatenationStatus.FINISH, world);
                return true;
            }
            try {
                task.run(world, this.context);
            }
            catch (Throwable exception) {
                CraftTweakerAPI.logError((String)"Exception occurred in a catenation task, stopping the catenation...", (Throwable)exception);
                this.context.setStatus(CatenationStatus.ERROR, world);
                return true;
            }
            if (task.isComplete()) {
                this.tasks.poll();
            }
        }
        return false;
    }

    @ZenMethod
    public void stop() {
        this.context.setStatus(CatenationStatus.STOP_MANUAL, this.world);
    }

    @ZenMethod
    public void pause() {
        this.context.setStatus(CatenationStatus.PAUSE, this.world);
    }

    @ZenMethod
    public void play() {
        this.context.setStatus(CatenationStatus.WORKING, this.world);
    }

    @ZenGetter(value="stopped")
    @ZenMethod
    public boolean isStopped() {
        return this.context.getStatus().isStop();
    }

    @ZenGetter(value="context")
    @ZenMethod
    public CatenationContext getContext() {
        return this.context;
    }

    public IWorld getWorld() {
        return this.world;
    }

    public void setWorld(IWorld world) {
        this.world = world;
    }

    public Queue<ICatenationTask> getTasks() {
        return this.tasks;
    }

    public void setPersistenceKey(@Nullable String persistenceKey) {
        this.persistenceKey = persistenceKey;
    }

    @Nullable
    public String getPersistenceKey() {
        return this.persistenceKey;
    }

    public boolean isAllObjectsValid() {
        return this.validateObjectHolders().isValid();
    }

    public ICatenationObjectHolder.ValidationResult validateObjectHolders() {
        return this.getContext().getObjectHolders().values().stream().map(holder -> {
            ICatenationObjectHolder.ValidationResult result = holder.validate(this);
            if (!result.isValid()) {
                holder.invalidate();
            }
            return result;
        }).max(Comparator.comparing(Enum::ordinal)).orElse(ICatenationObjectHolder.ValidationResult.VALID);
    }
}

